/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Context;
import org.openni.EnumerationErrors;
import org.openni.GeneralException;
import org.openni.NativeMethods;
import org.openni.NodeType;
import org.openni.OutArg;
import org.openni.ProductionNode;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class ScriptNode
extends ProductionNode {
    ScriptNode(Context context, long l, boolean bl) throws StatusException {
        super(context, l, bl);
    }

    public static ScriptNode create(Context context, String string) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateScriptNode(context.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        ScriptNode scriptNode = (ScriptNode)context.createProductionNodeObject((Long)outArg.value, NodeType.SCRIPT_NODE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return scriptNode;
    }

    public String getSupportedFormat() {
        return NativeMethods.xnScriptNodeGetSupportedFormat(this.toNative());
    }

    public void loadScriptFromFile(String string) throws StatusException {
        int n = NativeMethods.xnLoadScriptFromFile(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void loadScriptFromString(String string) throws StatusException {
        int n = NativeMethods.xnLoadScriptFromString(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void Run(EnumerationErrors enumerationErrors) throws StatusException {
        int n = NativeMethods.xnScriptNodeRun(this.toNative(), enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
    }
}

