/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Context;
import org.openni.EnumerationErrors;
import org.openni.GeneralException;
import org.openni.Generator;
import org.openni.IObservable;
import org.openni.NativeMethods;
import org.openni.NodeType;
import org.openni.Observable;
import org.openni.OutArg;
import org.openni.Point3D;
import org.openni.PoseDetectionCapability;
import org.openni.Query;
import org.openni.SceneMetaData;
import org.openni.SkeletonCapability;
import org.openni.StatusException;
import org.openni.UserEventArgs;
import org.openni.WrapperUtils;

public class UserGenerator
extends Generator {
    private Observable<UserEventArgs> newUserEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, "callback", null, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable<UserEventArgs> lostUserEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, null, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable<UserEventArgs> userExitEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToUserExit(UserGenerator.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable<UserEventArgs> userReenterEvent = new Observable<UserEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToUserReEnter(UserGenerator.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };

    UserGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static UserGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateUserGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        UserGenerator userGenerator = (UserGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.USER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return userGenerator;
    }

    public static UserGenerator create(Context context, Query query) throws GeneralException {
        return UserGenerator.create(context, query, null);
    }

    public static UserGenerator create(Context context) throws GeneralException {
        return UserGenerator.create(context, null, null);
    }

    public int getNumberOfUsers() {
        return NativeMethods.xnGetNumberOfUsers(this.toNative());
    }

    public int[] getUsers() throws StatusException {
        OutArg<Integer[]> outArg = new OutArg<Integer[]>();
        int n = NativeMethods.xnGetUsers(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        int[] nArray = new int[((Integer[])outArg.value).length];
        for (int i = 0; i < ((Integer[])outArg.value).length; ++i) {
            nArray[i] = ((Integer[])outArg.value)[i];
        }
        return nArray;
    }

    public Point3D getUserCoM(int n) throws StatusException {
        OutArg<Point3D> outArg = new OutArg<Point3D>();
        int n2 = NativeMethods.xnGetUserCoM(this.toNative(), n, outArg);
        WrapperUtils.throwOnError(n2);
        return (Point3D)outArg.value;
    }

    public void getUserPixels(int n, SceneMetaData sceneMetaData) {
        NativeMethods.xnGetUserPixels(this.toNative(), n, sceneMetaData);
    }

    public SceneMetaData getUserPixels(int n) {
        SceneMetaData sceneMetaData = new SceneMetaData();
        this.getUserPixels(n, sceneMetaData);
        return sceneMetaData;
    }

    public PoseDetectionCapability getPoseDetectionCapability() throws StatusException {
        return new PoseDetectionCapability(this);
    }

    public SkeletonCapability getSkeletonCapability() throws StatusException {
        return new SkeletonCapability(this);
    }

    public IObservable<UserEventArgs> getNewUserEvent() {
        return this.newUserEvent;
    }

    public IObservable<UserEventArgs> getLostUserEvent() {
        return this.lostUserEvent;
    }

    public IObservable<UserEventArgs> getUserExitEvent() {
        return this.userExitEvent;
    }

    public IObservable<UserEventArgs> getUserReenterEvent() {
        return this.userReenterEvent;
    }
}

