/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.CapabilityBase;
import org.openni.IStateChangedObservable;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.PowerLineFrequency;
import org.openni.ProductionNode;
import org.openni.StateChangedObservable;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class AntiFlickerCapability
extends CapabilityBase {
    private StateChangedObservable powerLineFrequencyChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), l);
        }
    };

    public AntiFlickerCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public PowerLineFrequency getPowerLineFrequency() {
        return PowerLineFrequency.fromNative(NativeMethods.xnGetPowerLineFrequency(this.toNative()));
    }

    public void setPowerLineFrequency(PowerLineFrequency powerLineFrequency) throws StatusException {
        int n = NativeMethods.xnSetPowerLineFrequency(this.toNative(), powerLineFrequency.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getPowerLineFrequencyChangedEvent() {
        return this.powerLineFrequencyChanged;
    }
}

