/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.CapabilityBase;
import org.openni.Generator;
import org.openni.IStateChangedObservable;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.ProductionNode;
import org.openni.StateChangedObservable;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class FrameSyncCapability
extends CapabilityBase {
    private StateChangedObservable frameSyncChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToFrameSyncChange(FrameSyncCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromFrameSyncChange(FrameSyncCapability.this.toNative(), l);
        }
    };

    public FrameSyncCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public boolean canFrameSyncWith(Generator generator) {
        return NativeMethods.xnCanFrameSyncWith(this.toNative(), generator.toNative());
    }

    public void frameSyncWith(Generator generator) throws StatusException {
        int n = NativeMethods.xnFrameSyncWith(this.toNative(), generator.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void stopFrameSyncWith(Generator generator) throws StatusException {
        int n = NativeMethods.xnStopFrameSyncWith(this.toNative(), generator.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isFrameSyncedWith(Generator generator) {
        return NativeMethods.xnIsFrameSyncedWith(this.toNative(), generator.toNative());
    }

    public IStateChangedObservable getFrameSyncChangedEvent() {
        return this.frameSyncChanged;
    }
}

