package Alien::Gimp;

use strict;
use warnings;

our $VERSION = '0.10';

my %config = (
            'gimptool' => '/opt/local/bin/gimptool-2.0',
            'gimp' => '/opt/local/bin/gimp-2.10',
            'gimpplugindir' => '/opt/local/lib/gimp/2.0/plug-ins'
          );


sub gimp { $config{gimp} }
sub gimptool { $config{gimptool} }
sub gimpplugindir { $config{gimpplugindir} }

sub Inline {
  require Alien::Gimp::Install::Files;
  goto &Alien::Gimp::Install::Files::Inline;
}

1;

__END__

=head1 NAME

Alien::Gimp - Encapsulate install info for GIMP

=head1 SYNOPSIS

  # Gimp/Makefile.PL
  use ExtUtils::Depends;
  my $pkg = ExtUtils::Depends->new(qw(Gimp Alien::Gimp)); # GIMP config info

  use Alien::Gimp;
  say Alien::Gimp->gimpplugindir;

=head1 DESCRIPTION

Use in your F<Makefile.PL> as above. Produces config info usable via
L<ExtUtils::Depends>.

Available methods:

=head2 gimp

The path of the GIMP executable.

=head2 gimptool

The path of the F<gimptool> executable.

=head2 gimpplugindir

The path of the GIMP plug-in directory.

=head1 AUTHOR

Ed J

=head1 SEE ALSO

L<Gimp>, L<ExtUtils::Depends>.
