#!/bin/sh
#
# simple web interface to pflogsumm 3/18/99
# 3/21/99 enhanced to look at multiple maillogs
# 4/16/99 meta refresh for killpf
# 4/23/99 entire uses $cat so 'rsh mailhost /bin/cat' will work in $cat/$zcat
#
# chris@nmedia.net
#
# Note the user who the cgi runs as must be able to run pflogsumm/ps/cat and
# read the specified mail logs... Also, this script assumes that your 
# logs are either not rotated much at all or are rotated at most once per day.
# If your maillogs are rotated more then once a day, the results for
# the 'today' and 'yesterday' options may not cover the full day!
#
# If you are using pflogsumm-beta from 3/21/99 or a release version
# from a later date then you should comment out the current "opts" entry
# below and uncomment the new one!
#
# If you are not getting any results, run this program from the command line
# with appropriate arguments (yesterday, today, entire, all, one, two, ...)
# to see the errors that are being generated!
#
# If you run this on a host that is not your mail server, you can
# define 'cat' and 'zcat' to be something like 'rsh mailhost /bin/cat'
# and/or 'rsh mailhost /usr/bin/zcat' or something like that...Or ssh..
# From Geoff Gibbs <ggibbs@hgmp.mrc.ac.uk>
#
ps="/bin/ps"		# or /bin/ps for BSD
host="highsierra.internal.macports.net"		# change to your mail server
maillog="/var/log/mail.log"	# change to your mail log
maillog0="/var/log/mail.log.0.gz"	# or maillog.0.gz
maillog1="/var/log/mail.log.1.gz"	# or maillog.1.gz
maillog2="/var/log/mail.log.2.gz"	# or maillog.2.gz
maillog3="/var/log/mail.log.3.gz"	# or maillog.3.gz
zcat="/usr/bin/zcat"			# or /usr/bin/zcat if your rotated logs are compressed
cat="/bin/cat"			# almost always /bin/cat
pflog="/opt/local/bin/pflogsumm"	# or /usr/local/bin/pflogsumm-beta.pl
# opts="-c 100"			# Extra options to use with pflogsumm
opts="-h 150 -u 100"		# Next version of pflogsumm changes options!
scr="pflogsumm.cgi"			# name of this script (if index.cgi, you can leave it blank)
#
# disable filename globbing
set -f
#
echo "Content-type: text/html"
echo
echo
echo "<HTML><HEAD><TITLE>$host statistics: $1</TITLE>"
echo "<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\"> <CENTER>"
echo "<H1><tt>$host</tt></h1>"
echo "<P>"
if test "$1" = ""; then
echo "</CENTER>"
echo "<FONT SIZE=\"+2\">"
echo "<UL>"
echo "<LI><A HREF=\"$scr?today\">Mail server statistics for <B><BIG>today</B></BIG></A>"
echo "<LI><A HREF=\"$scr?yesterday\">Mail server statistics for <B><BIG>yesterday</B></BIG></a>"
echo "<LI><A HREF=\"$scr?entire\">Mail server statistics for the <B><BIG>full current</B></BIG> maillog</a>"
echo "<LI><A HREF=\"$scr?all\">Mail server statistics including the <B><BIG>current and last four rotations</B></BIG> of the maillog</a>"
echo "<LI><A HREF=\"$scr?one\">Mail server statistics for the <B><BIG>first rotation</b></Big> of the maillog</a>"
echo "<LI><A HREF=\"$scr?two\">Mail server statistics for the <B><BIG>second rotation</b></big> of the maillog</a>"
echo "<LI><A href=\"$scr?three\">Mail server statistics for the <B><BIG>third rotation</b></big> of the maillog</a>"
echo "<LI><A href=\"$scr?four\">Mail server statistics for the <B><BIG>fourth rotation</b></big> of the maillog</a>"
echo "<LI><A href=\"$scr?killpf\">Kill <B><BIG>any running</B></BIG> statistics generator processes</a>"
echo "</FONT>"
echo "</BODY></HTML>"
exit
fi

if test "$1" = "killpf"; then
killname() {
	pid=`$ps -ax |
	/usr/bin/grep -w "$1" |
	/usr/bin/sed -e 's/^  *//' -e 's/ .*//'`
	[ "$pid" != "" ] && kill -9 $pid
}
echo "Killing pflogsumm processes... Please wait."
echo "<meta http-equiv=\"refresh\" content=\"2; URL=$scr?\">"
killname $pflog
exit
fi

echo "<h2>statistics: $1</H2>"
echo "It may take several minutes for the server to generate these"
echo "statistics.  Please be patient."
echo "  "

if test "$1" = "yesterday"; then
echo "Statistics for yesterday...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
($zcat $maillog1 $maillog0;$cat $maillog)|$pflog $opts -d yesterday 2>&1
done=yes
fi

if test "$1" = "today"; then
echo "Statistics for today...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
($zcat $maillog0;$cat $maillog)|$pflog $opts -d today 2>&1
done=yes
fi

if test "$1" = "entire"; then
echo "Statistics for the current maillog...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
$cat $maillog|$pflog $opts 2>&1
done=yes
fi

if test "$1" = "all"; then
echo "Statistics including the current and last four maillogs...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
($zcat $maillog3 $maillog2 $maillog1 $maillog0;$cat $maillog)|$pflog $opts 2>&1
done=yes
fi

if test "$1" = "one"; then
echo "Statistics for the first rotation of the maillog...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
$zcat $maillog0 | $pflog $opts 2>&1
done=yes
fi

if test "$1" = "two"; then
echo "Statistics for the second rotation of the maillog...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
$zcat $maillog1 | $pflog $opts 2>&1
done=yes
fi

if test "$1" = "three"; then
echo "Statistics for the third rotation of the maillog...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
$zcat $maillog2 | $pflog $opts 2>&1
done=yes
fi

if test "$1" = "four"; then
echo "Statistics for the fourth rotation of the maillog...<BR><HR WIDTH=\"75%\">"
echo "</CENTER><PRE>"
$zcat $maillog3 | $pflog $opts 2>&1
done=yes
fi

if test "$done" != "yes"; then
echo "</PRE><CENTER><H1>No Soup For You!</H1></CENTER>"
else
echo "</PRE>"
fi

echo " "
echo "<H2>---End---</H2>"
