/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse;

import fr.zenexity.pdt.editors.EditorHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class FilesAccess {
    public static IEditorPart openFile(IFile file, IWorkbenchWindow window) throws CoreException {
        IEditorPart result = null;
        IWorkbenchPage page = FilesAccess.getCurrentPage();
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        result = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
        marker.delete();
        return result;
    }

    public static void goToLine(IEditorPart editor, int line) {
        IMarker marker = null;
        try {
            marker = FilesAccess.getFile(editor).createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttribute("lineNumber", line);
        }
        catch (CoreException coreException) {}
        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
    }

    public static void goToCharacter(IEditorPart editor, int character) {
        IMarker marker = null;
        try {
            marker = FilesAccess.getFile(editor).createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttribute("charStart", character);
        }
        catch (CoreException coreException) {}
        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
    }

    public static void goToLineContaining(IEditorPart editorPart, String text) {
        EditorHelper editor = new EditorHelper((ITextEditor)editorPart);
        int lineNo = -1;
        int i = 0;
        int length = editor.lineCount();
        IDocument doc = editor.getDocument();
        try {
            while (i < length && lineNo < 0) {
                String line = doc.get(doc.getLineOffset(i), doc.getLineLength(i));
                if (line.contains(text)) {
                    lineNo = i;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        FilesAccess.goToLine(editorPart, i);
    }

    public static void createAndOpen(IFile file, String content, FileType type) {
        IWorkbenchPage page = FilesAccess.getCurrentPage();
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        try {
            file.create((InputStream)source, false, null);
            page.openEditor((IEditorInput)new FileEditorInput(file), type.editorID, true, 1);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static IFile getFile(IEditorPart editorPart) {
        return ((IFileEditorInput)editorPart.getEditorInput()).getFile();
    }

    private static IWorkbenchPage getCurrentPage() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        return page;
    }

    public static enum FileType {
        JAVA("org.eclipse.jdt.ui.CompilationUnitEditor"),
        HTML("tk.eclipse.plugin.htmleditor.editors.HTMLEditor"),
        CSS("tk.eclipse.plugin.htmleditor.editors.HTMLEditor"),
        JS("tk.eclipse.plugin.htmleditor.editors.HTMLEditor");

        private String editorID;

        private FileType(String editorID) {
            this.editorID = editorID;
        }
    }
}

