/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.handlers;

import fr.zenexity.pdt.editors.EditorHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.playframework.playclipse.Navigation;
import org.playframework.playclipse.editors.html.HTMLEditor;
import org.playframework.playclipse.editors.route.RouteEditor;

public class GoToActionHandler
extends AbstractHandler {
    private String fromView(EditorHelper editor) {
        String action;
        String line = editor.getLine(editor.getCurrentLineNo());
        Pattern pt = Pattern.compile("@\\{([^}]+)\\}");
        Matcher m = pt.matcher(line);
        if (m.find()) {
            action = m.group().replace("@{", "").replace("}", "").replace("(.*)", "");
            if (!action.contains(".")) {
                action = String.valueOf(editor.enclosingDirectory()) + "." + action;
            }
        } else {
            action = String.valueOf(editor.enclosingDirectory()) + "." + editor.getTitle().replace(".html", "");
        }
        return action;
    }

    private String fromRoutes(EditorHelper editor) {
        String line = editor.getLine(editor.getCurrentLineNo());
        String[] lineArr = line.trim().split("\\s+");
        return lineArr[lineArr.length - 1];
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String action = null;
        EditorHelper editor = EditorHelper.getCurrent(event);
        if (editor.textEditor instanceof HTMLEditor) {
            action = this.fromView(editor);
            System.out.println("View!!");
        } else if (editor.textEditor instanceof RouteEditor) {
            action = this.fromRoutes(editor);
            System.out.println("Routes!!");
        }
        System.out.println("action = " + action);
        new Navigation(editor).goToAction(action);
        return null;
    }
}

