/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.playframework.playclipse.wizards.PlayWizardPage;

public abstract class ClassWizardPage
extends PlayWizardPage {
    private Button packageBrowse;
    protected Text packageText;

    protected abstract String defaultPackage();

    protected abstract String nameLabel();

    public ClassWizardPage(ISelection selection) {
        super(selection);
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("Source fol&der:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClassWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("Package name:");
        this.packageText = new Text(container, 2052);
        gd = new GridData(768);
        this.packageText.setLayoutData((Object)gd);
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClassWizardPage.this.dialogChanged();
            }
        });
        this.packageBrowse = new Button(container, 8);
        this.packageBrowse.setText("Browse...");
        this.packageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClassWizardPage.this.handlePackageBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(this.nameLabel());
        this.name = new Text(container, 2052);
        gd = new GridData(768);
        this.name.setLayoutData((Object)gd);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClassWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof ICompilationUnit) {
                obj = ((ICompilationUnit)obj).getParent();
            }
            if (obj instanceof IJavaElement) {
                this.packageText.setText(((IJavaElement)obj).getElementName());
            }
        }
        if (this.packageText.getText().isEmpty()) {
            this.packageText.setText(this.defaultPackage());
        }
        if (this.project == null) {
            this.packageBrowse.setEnabled(false);
        }
    }

    private void handlePackageBrowse() {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)this.getShell(), (IJavaProject)javaProject, (int)0);
            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                this.packageText.setText(((IPackageFragment)result[0]).getElementName());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", this.name.getText());
        result.put("container", this.containerText.getText());
        result.put("package", this.packageText.getText());
        return result;
    }
}

