/*
 * Decompiled with CFR 0.152.
 */
package fr.zenexity.pdt.editors;

import fr.zenexity.pdt.editors.Editor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;

public class AutoCloser
implements VerifyKeyListener {
    Editor editor;
    SourceViewer sourceViewer;
    protected static final char BACKSPACE = '\b';
    protected static final char CARRAIGE_RETURN = '\r';
    protected static final char NEWLINE = '\n';
    protected static final char TAB = '\t';
    protected static final char SPACE = ' ';

    public AutoCloser(Editor editor, SourceViewer sourceViewer) {
        this.editor = editor;
        this.sourceViewer = sourceViewer;
    }

    protected void moveCursor(int cursorDelta) {
        int widgetCursorPos = this.sourceViewer.getTextWidget().getCaretOffset();
        int docCursorPos = this.sourceViewer.widgetOffset2ModelOffset(widgetCursorPos);
        this.sourceViewer.setSelectedRange(docCursorPos + cursorDelta, 0);
    }

    public void verifyKey(VerifyEvent event) {
        try {
            IDocument document = this.sourceViewer.getDocument();
            Point selection = this.sourceViewer.getSelectedRange();
            int cursorOffset = selection.x;
            int selectionLength = selection.y;
            char c = event.character;
            char pc = document.getChar(cursorOffset - 1);
            char nc = '\u0000';
            try {
                nc = document.getChar(cursorOffset);
            }
            catch (Exception exception) {}
            String insert = this.editor.autoClose(pc, c, nc);
            if (insert != null && insert.equals(Editor.SKIP)) {
                event.doit = false;
                this.moveCursor(1);
            } else if (insert != null) {
                insert = String.valueOf(c) + insert;
                document.replace(cursorOffset, selectionLength, insert);
                event.doit = false;
                this.moveCursor(1);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

