/*
 * Decompiled with CFR 0.152.
 */
package build.please.common.source;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceMap {
    public static Map<String, String> readSourceMap() {
        return SourceMap.readSourceMap(new File("META-INF", "please_sourcemap").getPath());
    }

    public static Map<String, String> readSourceMap(String resourcePath) {
        return SourceMap.readSourceMap(SourceMap.class.getClassLoader().getResourceAsStream(resourcePath));
    }

    public static Map<String, String> readSourceMap(InputStream inputStream) {
        LinkedHashMap<String, String> sourceMap = new LinkedHashMap<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                String[] parts = line.trim().split(" ");
                if (parts.length == 2) {
                    sourceMap.put(parts[1], SourceMap.deriveOriginalFilename(parts[0], parts[1]));
                    continue;
                }
                if (parts.length != 1 || !line.startsWith(" ")) continue;
                sourceMap.put(parts[0], parts[0]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Failed to read sourcemap. Coverage results may be inaccurate.");
        }
        return sourceMap;
    }

    public static String deriveOriginalFilename(String packageName, String className) {
        String[] packagePath = packageName.split("/");
        String[] classPath = className.split("/");
        for (int size = classPath.length - 1; size > 0; --size) {
            int i;
            if (size >= packagePath.length || !SourceMap.matchArrays(packagePath, classPath, size)) continue;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < packagePath.length; ++i) {
                sb.append(packagePath[i]);
                sb.append('/');
            }
            for (i = size; i < classPath.length; ++i) {
                if (i > size) {
                    sb.append('/');
                }
                sb.append(classPath[i]);
            }
            return sb.toString();
        }
        if (!packageName.isEmpty()) {
            return packageName + '/' + className;
        }
        return className;
    }

    private static boolean matchArrays(String[] a, String[] b, int size) {
        int i = 0;
        int j = a.length - size;
        while (i < size) {
            if (!a[j].equals(b[i])) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }
}

