/*
 * Decompiled with CFR 0.152.
 */
package build.please.cover.runner;

import build.please.vendored.org.jacoco.core.instr.Instrumenter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InstrumentingClassLoader
extends ClassLoader {
    private final Instrumenter instrumenter;
    private final Map<String, Class<?>> instrumentedClasses = new HashMap();

    InstrumentingClassLoader(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    void addInstrumentedClasses(Set<String> classes) {
        for (String cls : classes) {
            this.instrumentedClasses.put(cls, null);
        }
    }

    Iterable<Class<?>> getInstrumentedClasses() {
        return this.instrumentedClasses.values();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            Class<?> cls = this.instrumentedClasses.get(name);
            if (cls != null) {
                return cls;
            }
            if (this.instrumentedClasses.containsKey(name)) {
                byte[] instrumented = this.instrumenter.instrument(InstrumentingClassLoader.getTargetClass(InstrumentingClassLoader.class, name), name);
                cls = this.defineClass(name, instrumented, 0, instrumented.length, this.getClass().getProtectionDomain());
                this.instrumentedClasses.put(name, cls);
                return cls;
            }
            return super.loadClass(name, resolve);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static InputStream getTargetClass(Class cls, String name) {
        String resource = '/' + name.replace('.', '/') + ".class";
        return cls.getResourceAsStream(resource);
    }
}

