/*
 * Decompiled with CFR 0.152.
 */
package build.please.test.report;

import build.please.test.result.ErrorCaseResult;
import build.please.test.result.FailureCaseResult;
import build.please.test.result.SkippedCaseResult;
import build.please.test.result.TestCaseResult;
import build.please.test.result.TestSuiteResult;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlTestReporter {
    public Document buildDocument(TestSuiteResult suiteResult) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        doc.setXmlVersion("1.0");
        Element root = XmlTestReporter.createTestSuiteElement(doc, suiteResult);
        doc.appendChild(root);
        XmlTestReporter.showProperties(doc, root);
        for (TestCaseResult result : suiteResult.caseResults) {
            Element test = doc.createElement("testcase");
            result.renderToXml(doc, test);
            root.appendChild(test);
        }
        return doc;
    }

    private static Element createTestSuiteElement(Document doc, TestSuiteResult result) {
        String hostname;
        Element root = doc.createElement("testsuite");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "http://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd");
        root.setAttribute("name", result.getClassName());
        root.setAttribute("time", Double.toString((double)result.duration / 1000.0));
        root.setAttribute("timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(new Date()));
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostname = "unknown";
        }
        root.setAttribute("hostname", hostname);
        int tests = 0;
        int errors = 0;
        int skipped = 0;
        int failures = 0;
        for (TestCaseResult tcr : result.caseResults) {
            ++tests;
            if (tcr instanceof SkippedCaseResult) {
                ++skipped;
                continue;
            }
            if (tcr instanceof ErrorCaseResult) {
                ++errors;
                continue;
            }
            if (!(tcr instanceof FailureCaseResult)) continue;
            ++failures;
        }
        root.setAttribute("tests", Integer.toString(tests));
        root.setAttribute("errors", Integer.toString(errors));
        root.setAttribute("skipped", Integer.toString(skipped));
        root.setAttribute("failures", Integer.toString(failures));
        return root;
    }

    private static void showProperties(Document doc, Element root) {
        Element properties = doc.createElement("properties");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Element property = doc.createElement("property");
            String name = entry.getKey().toString();
            Object v = entry.getValue();
            String value = v == null ? "null" : v.toString();
            property.setAttribute("name", name);
            property.setAttribute("value", value);
            properties.appendChild(property);
        }
        root.appendChild(properties);
    }
}

