/*
 * Decompiled with CFR 0.152.
 */
package build.please.test.result;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TestCaseResult {
    private final String className;
    private final String name;
    private final String group;
    long durationMillis;
    private String stdOut;
    private String stdErr;

    public TestCaseResult(String className, String name) {
        this.className = className;
        this.name = name;
        this.group = null;
    }

    public abstract boolean isSuccess();

    public void setStdOut(String stdOut) {
        this.stdOut = stdOut;
    }

    public void setStdErr(String stdErr) {
        this.stdErr = stdErr;
    }

    public void setDuration(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public void renderToXml(Document doc, Element testCaseElement) {
        testCaseElement.setAttribute("name", this.name);
        if (this.className != null) {
            testCaseElement.setAttribute("classname", this.className);
        }
        testCaseElement.setAttribute("time", Double.toString((double)this.durationMillis / 1000.0));
        if (this.group != null) {
            testCaseElement.setAttribute("group", this.group);
        }
        if (this.stdOut != null) {
            Element sysOut = doc.createElement("system-out");
            sysOut.setTextContent(this.stdOut);
            testCaseElement.appendChild(sysOut);
        }
        if (this.stdErr != null) {
            Element sysErr = doc.createElement("system-err");
            sysErr.setTextContent(this.stdErr);
            testCaseElement.appendChild(sysErr);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    public String getStdErr() {
        return this.stdErr;
    }
}

