/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.core.analysis;

import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.ICoverageVisitor;
import build.please.vendored.org.jacoco.core.analysis.ISourceFileCoverage;
import build.please.vendored.org.jacoco.core.internal.analysis.BundleCoverageImpl;
import build.please.vendored.org.jacoco.core.internal.analysis.SourceFileCoverageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageBuilder
implements ICoverageVisitor {
    private final Map<String, IClassCoverage> classes = new HashMap<String, IClassCoverage>();
    private final Map<String, ISourceFileCoverage> sourcefiles = new HashMap<String, ISourceFileCoverage>();

    public Collection<IClassCoverage> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Collection<ISourceFileCoverage> getSourceFiles() {
        return Collections.unmodifiableCollection(this.sourcefiles.values());
    }

    public IBundleCoverage getBundle(String name) {
        return new BundleCoverageImpl(name, this.classes.values(), this.sourcefiles.values());
    }

    public Collection<IClassCoverage> getNoMatchClasses() {
        ArrayList<IClassCoverage> result = new ArrayList<IClassCoverage>();
        for (IClassCoverage c : this.classes.values()) {
            if (!c.isNoMatch()) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public void visitCoverage(IClassCoverage coverage) {
        String name = coverage.getName();
        IClassCoverage dup = this.classes.put(name, coverage);
        if (dup != null) {
            if (dup.getId() != coverage.getId()) {
                throw new IllegalStateException("Can't add different class with same name: " + name);
            }
        } else {
            String source = coverage.getSourceFileName();
            if (source != null) {
                SourceFileCoverageImpl sourceFile = this.getSourceFile(source, coverage.getPackageName());
                sourceFile.increment(coverage);
            }
        }
    }

    private SourceFileCoverageImpl getSourceFile(String filename, String packagename) {
        String key = packagename + '/' + filename;
        SourceFileCoverageImpl sourcefile = (SourceFileCoverageImpl)this.sourcefiles.get(key);
        if (sourcefile == null) {
            sourcefile = new SourceFileCoverageImpl(filename, packagename);
            this.sourcefiles.put(key, sourcefile);
        }
        return sourcefile;
    }
}

