/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.core.internal.analysis.filter;

import build.please.vendored.org.jacoco.core.internal.analysis.filter.IFilter;
import build.please.vendored.org.jacoco.core.internal.analysis.filter.IFilterContext;
import build.please.vendored.org.jacoco.core.internal.analysis.filter.IFilterOutput;
import build.please.vendored.org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import build.please.vendored.org.objectweb.asm.tree.AbstractInsnNode;
import build.please.vendored.org.objectweb.asm.tree.LineNumberNode;
import build.please.vendored.org.objectweb.asm.tree.MethodNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class KotlinInlineFilter
implements IFilter {
    private int firstGeneratedLineNumber = -1;
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]++)(#[0-9]++)?+(,[0-9]++)?+:([0-9]++)(,[0-9]++)?+");
    private static final Pattern FILE_INFO_PATTERN = Pattern.compile("\\+ ([0-9]++) (.++)");

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if (context.getSourceDebugExtension() == null) {
            return;
        }
        if (!KotlinGeneratedFilter.isKotlinClass(context)) {
            return;
        }
        if (this.firstGeneratedLineNumber == -1) {
            this.firstGeneratedLineNumber = KotlinInlineFilter.getFirstGeneratedLineNumber(context.getSourceFileName(), context.getSourceDebugExtension());
        }
        int line = 0;
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            if (15 == i.getType()) {
                line = ((LineNumberNode)i).line;
            }
            if (line < this.firstGeneratedLineNumber) continue;
            output.ignore(i, i);
        }
    }

    private static int getFirstGeneratedLineNumber(String sourceFileName, String smap) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new StringReader(smap));
            KotlinInlineFilter.expectLine(br, "SMAP");
            KotlinInlineFilter.expectLine(br, sourceFileName);
            KotlinInlineFilter.expectLine(br, "Kotlin");
            KotlinInlineFilter.expectLine(br, "*S Kotlin");
            KotlinInlineFilter.expectLine(br, "*F");
            BitSet sourceFileIds = new BitSet();
            while (!"*L".equals(line = br.readLine())) {
                br.readLine();
                Matcher m = FILE_INFO_PATTERN.matcher(line);
                if (!m.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                String fileName = m.group(2);
                if (!fileName.equals(sourceFileName)) continue;
                sourceFileIds.set(Integer.parseInt(m.group(1)));
            }
            if (sourceFileIds.isEmpty()) {
                throw new IllegalStateException("Unexpected SMAP FileSection");
            }
            int min = Integer.MAX_VALUE;
            while (!"*E".equals(line = br.readLine())) {
                Matcher m = LINE_INFO_PATTERN.matcher(line);
                if (!m.matches()) {
                    throw new IllegalStateException("Unexpected SMAP line: " + line);
                }
                int inputStartLine = Integer.parseInt(m.group(1));
                int lineFileID = Integer.parseInt(m.group(2).substring(1));
                int outputStartLine = Integer.parseInt(m.group(4));
                if (sourceFileIds.get(lineFileID) && inputStartLine == outputStartLine) continue;
                min = Math.min(outputStartLine, min);
            }
            return min;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void expectLine(BufferedReader br, String expected) throws IOException {
        String line = br.readLine();
        if (!expected.equals(line)) {
            throw new IllegalStateException("Unexpected SMAP line: " + line);
        }
    }
}

