/*
 * Decompiled with CFR 0.152.
 */
package build.please.cover.runner;

import build.please.cover.result.CoverageRunResult;
import build.please.cover.runner.InstrumentingClassLoader;
import build.please.test.result.TestSuiteResult;
import build.please.test.runner.PleaseTestRunner;
import build.please.vendored.org.jacoco.core.analysis.Analyzer;
import build.please.vendored.org.jacoco.core.analysis.CoverageBuilder;
import build.please.vendored.org.jacoco.core.data.ExecutionDataStore;
import build.please.vendored.org.jacoco.core.data.SessionInfoStore;
import build.please.vendored.org.jacoco.core.instr.Instrumenter;
import build.please.vendored.org.jacoco.core.runtime.IRuntime;
import build.please.vendored.org.jacoco.core.runtime.LoggerRuntime;
import build.please.vendored.org.jacoco.core.runtime.RuntimeData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public class PleaseCoverageRunner {
    private final IRuntime runtime;
    private final InstrumentingClassLoader instrumentingClassLoader;
    private PleaseTestRunner runner;

    public PleaseCoverageRunner(PleaseTestRunner runner) {
        this.runner = runner;
        this.runtime = new LoggerRuntime();
        Instrumenter instrumenter = new Instrumenter(this.runtime);
        this.instrumentingClassLoader = new InstrumentingClassLoader(instrumenter);
    }

    public void instrument(Set<String> classes) throws ClassNotFoundException {
        this.instrumentingClassLoader.addInstrumentedClasses(classes);
        for (String cls : classes) {
            this.instrumentingClassLoader.loadClass(cls);
        }
    }

    public CoverageRunResult runTests(Set<String> classes) throws Exception {
        CoverageRunResult result = new CoverageRunResult();
        RuntimeData data = new RuntimeData();
        this.runtime.startup(data);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.instrumentingClassLoader);
        for (String testClass : classes) {
            TestSuiteResult testSuiteResult = this.runner.runTest(this.instrumentingClassLoader.loadClass(testClass));
            if (testSuiteResult == null) continue;
            result.testClassNames.add(testClass);
            result.testResults.add(testSuiteResult);
        }
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        ExecutionDataStore executionData = new ExecutionDataStore();
        SessionInfoStore sessionInfo = new SessionInfoStore();
        data.collect(executionData, sessionInfo, false);
        this.runtime.shutdown();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionData, coverageBuilder);
        for (Class<?> clz : this.instrumentingClassLoader.getInstrumentedClasses()) {
            if (clz == null) continue;
            InputStream targetClass = InstrumentingClassLoader.getTargetClass(clz, clz.getName());
            try {
                analyzer.analyzeClass(targetClass, clz.getName());
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
        }
        result.coverageBuilder = coverageBuilder;
        return result;
    }
}

