/*
 * Decompiled with CFR 0.152.
 */
package build.please.test.runner;

import build.please.test.result.TestSuiteResult;
import build.please.test.runner.TestListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.manipulation.Filter;

public class PleaseTestRunner {
    private final boolean captureOutput;
    private final String[] methodsToTest;

    public PleaseTestRunner(boolean captureOutput, String ... methodsToTest) {
        this.captureOutput = captureOutput;
        this.methodsToTest = methodsToTest;
    }

    public TestSuiteResult runTest(Class testClass) {
        if (!this.isATestClass(testClass)) {
            return null;
        }
        JUnitCore core = new JUnitCore();
        TestListener listener = new TestListener(this.captureOutput);
        core.addListener(listener);
        Request request = Request.aClass(testClass);
        for (String aMethodsToTest : this.methodsToTest) {
            request = request.filterWith(Filter.matchMethodDescription(PleaseTestRunner.testDescription(testClass, aMethodsToTest)));
        }
        core.run(request);
        return listener.getResult();
    }

    private static Description testDescription(Class<?> testClass, String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return Description.createTestDescription(testClass, s);
        }
        return Description.createTestDescription(s.substring(0, index), s.substring(index + 1), new Annotation[0]);
    }

    public List<TestSuiteResult> runTests(Set<String> classes) throws ClassNotFoundException {
        LinkedList<TestSuiteResult> results = new LinkedList<TestSuiteResult>();
        for (String clz : classes) {
            TestSuiteResult testSuiteResult = this.runTest(this.getClass().getClassLoader().loadClass(clz));
            if (testSuiteResult == null) continue;
            results.add(testSuiteResult);
        }
        return results;
    }

    protected boolean isATestClass(Class<?> clz) {
        if (clz.getName().startsWith("build.please.test.runner.testdata")) {
            return false;
        }
        for (Method method : clz.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return false;
    }
}

