/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.internal.html.page;

import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.analysis.ICoverageNode;
import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.report.ISourceFileLocator;
import build.please.vendored.org.jacoco.report.internal.ReportOutputFolder;
import build.please.vendored.org.jacoco.report.internal.html.HTMLElement;
import build.please.vendored.org.jacoco.report.internal.html.IHTMLReportContext;
import build.please.vendored.org.jacoco.report.internal.html.page.PackagePage;
import build.please.vendored.org.jacoco.report.internal.html.page.ReportPage;
import build.please.vendored.org.jacoco.report.internal.html.page.TablePage;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlePage
extends TablePage<ICoverageNode> {
    private final ISourceFileLocator locator;
    private IBundleCoverage bundle;

    public BundlePage(IBundleCoverage bundle, ReportPage parent, ISourceFileLocator locator, ReportOutputFolder folder, IHTMLReportContext context) {
        super(bundle.getPlainCopy(), parent, folder, context);
        this.bundle = bundle;
        this.locator = locator;
    }

    @Override
    public void render() throws IOException {
        this.renderPackages();
        super.render();
        this.bundle = null;
    }

    private void renderPackages() throws IOException {
        for (IPackageCoverage p : this.bundle.getPackages()) {
            if (!p.containsCode()) continue;
            String packagename = p.getName();
            String foldername = packagename.length() == 0 ? "default" : packagename.replace('/', '.');
            PackagePage page = new PackagePage(p, this, this.locator, this.folder.subFolder(foldername), this.context);
            page.render();
            this.addItem(page);
        }
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    @Override
    protected String getFileName() {
        return "index.html";
    }

    @Override
    protected void content(HTMLElement body) throws IOException {
        if (this.bundle.getPackages().isEmpty()) {
            body.p().text("No class files specified.");
        } else if (!this.bundle.containsCode()) {
            body.p().text("None of the analyzed classes contain code relevant for code coverage.");
        } else {
            super.content(body);
        }
    }
}

