/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.csv;

import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.ICounter;
import build.please.vendored.org.jacoco.core.analysis.ICoverageNode;
import build.please.vendored.org.jacoco.report.ILanguageNames;
import build.please.vendored.org.jacoco.report.csv.DelimitedWriter;
import java.io.IOException;

class ClassRowWriter {
    private static final ICoverageNode.CounterEntity[] COUNTERS = new ICoverageNode.CounterEntity[]{ICoverageNode.CounterEntity.INSTRUCTION, ICoverageNode.CounterEntity.BRANCH, ICoverageNode.CounterEntity.LINE, ICoverageNode.CounterEntity.COMPLEXITY, ICoverageNode.CounterEntity.METHOD};
    private final DelimitedWriter writer;
    private final ILanguageNames languageNames;

    public ClassRowWriter(DelimitedWriter writer, ILanguageNames languageNames) throws IOException {
        this.writer = writer;
        this.languageNames = languageNames;
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.writer.write("GROUP", "PACKAGE", "CLASS");
        for (ICoverageNode.CounterEntity entity : COUNTERS) {
            this.writer.write(entity.name() + "_MISSED");
            this.writer.write(entity.name() + "_COVERED");
        }
        this.writer.nextLine();
    }

    public void writeRow(String groupName, String packageName, IClassCoverage node) throws IOException {
        this.writer.write(groupName);
        this.writer.write(this.languageNames.getPackageName(packageName));
        String className = this.languageNames.getClassName(node.getName(), node.getSignature(), node.getSuperName(), node.getInterfaceNames());
        this.writer.write(className);
        for (ICoverageNode.CounterEntity entity : COUNTERS) {
            ICounter counter = node.getCounter(entity);
            this.writer.write(counter.getMissedCount());
            this.writer.write(counter.getCoveredCount());
        }
        this.writer.nextLine();
    }
}

