/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.core.internal.analysis;

import build.please.vendored.org.jacoco.core.analysis.CoverageNodeImpl;
import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.ICoverageNode;
import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.core.analysis.ISourceFileCoverage;
import build.please.vendored.org.jacoco.core.internal.analysis.PackageCoverageImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleCoverageImpl
extends CoverageNodeImpl
implements IBundleCoverage {
    private final Collection<IPackageCoverage> packages;

    public BundleCoverageImpl(String name, Collection<IPackageCoverage> packages) {
        super(ICoverageNode.ElementType.BUNDLE, name);
        this.packages = packages;
        this.increment(packages);
    }

    public BundleCoverageImpl(String name, Collection<IClassCoverage> classes, Collection<ISourceFileCoverage> sourcefiles) {
        this(name, BundleCoverageImpl.groupByPackage(classes, sourcefiles));
    }

    private static Collection<IPackageCoverage> groupByPackage(Collection<IClassCoverage> classes, Collection<ISourceFileCoverage> sourcefiles) {
        HashMap classesByPackage = new HashMap();
        for (IClassCoverage c : classes) {
            BundleCoverageImpl.addByName(classesByPackage, c.getPackageName(), c);
        }
        HashMap sourceFilesByPackage = new HashMap();
        for (ISourceFileCoverage s : sourcefiles) {
            BundleCoverageImpl.addByName(sourceFilesByPackage, s.getPackageName(), s);
        }
        HashSet packageNames = new HashSet();
        packageNames.addAll(classesByPackage.keySet());
        packageNames.addAll(sourceFilesByPackage.keySet());
        ArrayList<IPackageCoverage> result = new ArrayList<IPackageCoverage>();
        for (String name : packageNames) {
            List<ISourceFileCoverage> s;
            List<IClassCoverage> c = (List<IClassCoverage>)classesByPackage.get(name);
            if (c == null) {
                c = Collections.emptyList();
            }
            if ((s = (List<ISourceFileCoverage>)sourceFilesByPackage.get(name)) == null) {
                s = Collections.emptyList();
            }
            result.add(new PackageCoverageImpl(name, c, s));
        }
        return result;
    }

    private static <T> void addByName(Map<String, Collection<T>> map, String name, T value) {
        Collection<T> list = map.get(name);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(name, list);
        }
        list.add(value);
    }

    @Override
    public Collection<IPackageCoverage> getPackages() {
        return this.packages;
    }
}

