/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.internal.xml;

import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.analysis.IClassCoverage;
import build.please.vendored.org.jacoco.core.analysis.ICounter;
import build.please.vendored.org.jacoco.core.analysis.ICoverageNode;
import build.please.vendored.org.jacoco.core.analysis.ILine;
import build.please.vendored.org.jacoco.core.analysis.IMethodCoverage;
import build.please.vendored.org.jacoco.core.analysis.IPackageCoverage;
import build.please.vendored.org.jacoco.core.analysis.ISourceFileCoverage;
import build.please.vendored.org.jacoco.core.analysis.ISourceNode;
import build.please.vendored.org.jacoco.report.internal.xml.ReportElement;
import java.io.IOException;

public final class XMLCoverageWriter {
    public static void writeBundle(IBundleCoverage bundle, ReportElement element) throws IOException {
        for (IPackageCoverage p : bundle.getPackages()) {
            XMLCoverageWriter.writePackage(p, element);
        }
        XMLCoverageWriter.writeCounters(bundle, element);
    }

    private static void writePackage(IPackageCoverage p, ReportElement parent) throws IOException {
        ReportElement element = parent.packageElement(p.getName());
        for (IClassCoverage c : p.getClasses()) {
            XMLCoverageWriter.writeClass(c, element);
        }
        for (ISourceFileCoverage s : p.getSourceFiles()) {
            XMLCoverageWriter.writeSourceFile(s, element);
        }
        XMLCoverageWriter.writeCounters(p, element);
    }

    private static void writeClass(IClassCoverage c, ReportElement parent) throws IOException {
        ReportElement element = parent.classElement(c);
        for (IMethodCoverage m : c.getMethods()) {
            XMLCoverageWriter.writeMethod(m, element);
        }
        XMLCoverageWriter.writeCounters(c, element);
    }

    private static void writeMethod(IMethodCoverage m, ReportElement parent) throws IOException {
        ReportElement element = parent.method(m);
        XMLCoverageWriter.writeCounters(m, element);
    }

    private static void writeSourceFile(ISourceFileCoverage s, ReportElement parent) throws IOException {
        ReportElement element = parent.sourcefile(s.getName());
        XMLCoverageWriter.writeLines(s, element);
        XMLCoverageWriter.writeCounters(s, element);
    }

    public static void writeCounters(ICoverageNode node, ReportElement parent) throws IOException {
        for (ICoverageNode.CounterEntity counterEntity : ICoverageNode.CounterEntity.values()) {
            ICounter counter = node.getCounter(counterEntity);
            if (counter.getTotalCount() <= 0) continue;
            parent.counter(counterEntity, counter);
        }
    }

    private static void writeLines(ISourceNode source, ReportElement parent) throws IOException {
        int last = source.getLastLine();
        for (int nr = source.getFirstLine(); nr <= last; ++nr) {
            ILine line = source.getLine(nr);
            if (line.getStatus() == 0) continue;
            parent.line(nr, line);
        }
    }

    private XMLCoverageWriter() {
    }
}

