/*
 * Decompiled with CFR 0.152.
 */
package build.please.vendored.org.jacoco.report.xml;

import build.please.vendored.org.jacoco.core.analysis.IBundleCoverage;
import build.please.vendored.org.jacoco.core.data.ExecutionData;
import build.please.vendored.org.jacoco.core.data.SessionInfo;
import build.please.vendored.org.jacoco.report.IReportGroupVisitor;
import build.please.vendored.org.jacoco.report.IReportVisitor;
import build.please.vendored.org.jacoco.report.ISourceFileLocator;
import build.please.vendored.org.jacoco.report.internal.xml.ReportElement;
import build.please.vendored.org.jacoco.report.internal.xml.XMLCoverageWriter;
import build.please.vendored.org.jacoco.report.internal.xml.XMLGroupVisitor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public class XMLFormatter {
    private String outputEncoding = "UTF-8";

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public IReportVisitor createVisitor(final OutputStream output) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootVisitor
        implements IReportVisitor {
            private ReportElement report;
            private List<SessionInfo> sessionInfos;
            private XMLGroupVisitor groupVisitor;

            RootVisitor() {
            }

            @Override
            public void visitInfo(List<SessionInfo> sessionInfos, Collection<ExecutionData> executionData) throws IOException {
                this.sessionInfos = sessionInfos;
            }

            @Override
            public void visitBundle(IBundleCoverage bundle, ISourceFileLocator locator) throws IOException {
                this.createRootElement(bundle.getName());
                XMLCoverageWriter.writeBundle(bundle, this.report);
            }

            @Override
            public IReportGroupVisitor visitGroup(String name) throws IOException {
                this.createRootElement(name);
                this.groupVisitor = new XMLGroupVisitor(this.report, name);
                return this.groupVisitor;
            }

            private void createRootElement(String name) throws IOException {
                this.report = new ReportElement(name, output, XMLFormatter.this.outputEncoding);
                for (SessionInfo i : this.sessionInfos) {
                    this.report.sessioninfo(i);
                }
            }

            @Override
            public void visitEnd() throws IOException {
                if (this.groupVisitor != null) {
                    this.groupVisitor.visitEnd();
                }
                this.report.close();
            }
        }
        return new RootVisitor();
    }
}

