/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.text.MessageFormat;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleViolationFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRuleViolationFactory
implements RuleViolationFactory {
    private static final Object[] NO_ARGS = new Object[0];

    private String cleanup(String message, Object[] args) {
        if (message != null) {
            String escapedMessage = StringUtils.replace((String)message, (String)"${", (String)"$'{'");
            return MessageFormat.format(escapedMessage, args != null ? args : NO_ARGS);
        }
        return message;
    }

    @Override
    public void addViolation(RuleContext ruleContext, Rule rule, Node node, String message, Object[] args) {
        String formattedMessage = this.cleanup(message, args);
        ruleContext.getReport().addRuleViolation(this.createRuleViolation(rule, ruleContext, node, formattedMessage));
    }

    @Override
    public void addViolation(RuleContext ruleContext, Rule rule, Node node, String message, int beginLine, int endLine, Object[] args) {
        String formattedMessage = this.cleanup(message, args);
        ruleContext.getReport().addRuleViolation(this.createRuleViolation(rule, ruleContext, node, formattedMessage, beginLine, endLine));
    }

    protected abstract RuleViolation createRuleViolation(Rule var1, RuleContext var2, Node var3, String var4);

    protected abstract RuleViolation createRuleViolation(Rule var1, RuleContext var2, Node var3, String var4, int var5, int var6);
}

