/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data;

import apex.jorje.data.Identifier;
import apex.jorje.data.Identifiers;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.data.ast.TypeRef;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreLists;
import java.util.List;
import java.util.Optional;

public class CompilationUnitBuilder {
    private final Identifier name;
    private Location loc;
    private Optional<TypeRef> superTypeRef;
    private List<TypeRef> interfaceRefs;
    private List<Modifier> modifiers;
    private Optional<List<Identifier>> typeParameters;
    private List<BlockMember> members;
    private List<Identifier> enumMembers;
    private List<Identifier> triggerTarget;
    private List<TriggerUsage> usages;
    private boolean isBulk;

    private CompilationUnitBuilder(Identifier name) {
        this.name = name;
        this.loc = Locations.NONE;
        this.typeParameters = Optional.empty();
        this.superTypeRef = Optional.empty();
        this.interfaceRefs = ImmutableList.of();
        this.modifiers = ImmutableList.of();
        this.members = ImmutableList.of();
        this.enumMembers = ImmutableList.of();
        this.triggerTarget = Identifiers.newIdentifiers("target");
        this.usages = ImmutableList.of();
        this.isBulk = false;
    }

    public static CompilationUnitBuilder builder(String name) {
        return new CompilationUnitBuilder(Identifiers.newIdentifier(name));
    }

    public static CompilationUnitBuilder builder(Identifier name) {
        return new CompilationUnitBuilder(name);
    }

    public static CompilationUnit anonymous(BlockMember ... members) {
        return CompilationUnit._AnonymousBlockUnit(MoreLists.asImmutableList(members));
    }

    public static CompilationUnit emptyEnum(String name) {
        return CompilationUnitBuilder.builder(name).buildEnum();
    }

    public static CompilationUnit emptyInterface(String name) {
        return CompilationUnitBuilder.builder(name).buildInterface();
    }

    public static CompilationUnit emptyClass(String name) {
        return CompilationUnitBuilder.builder(name).buildClass();
    }

    public static CompilationUnit emptyTrigger(String name) {
        return CompilationUnitBuilder.builder(name).buildTrigger();
    }

    public CompilationUnitBuilder setLoc(int index, int length) {
        this.loc = Locations.index(index, length);
        return this;
    }

    public CompilationUnitBuilder setSuperType(TypeRef superType) {
        this.superTypeRef = Optional.of(superType);
        return this;
    }

    public CompilationUnitBuilder setInterfaces(TypeRef ... interfaces) {
        this.interfaceRefs = MoreLists.asImmutableList(interfaces);
        return this;
    }

    public CompilationUnitBuilder setMembers(BlockMember ... members) {
        this.members = MoreLists.asImmutableList(members);
        return this;
    }

    public CompilationUnitBuilder setEnumMembers(String ... members) {
        return this.setEnumMembers(Identifiers.newIdentifiers(members));
    }

    public CompilationUnitBuilder setEnumMembers(Identifier ... members) {
        return this.setEnumMembers(MoreLists.asImmutableList(members));
    }

    private CompilationUnitBuilder setEnumMembers(List<Identifier> members) {
        this.enumMembers = members;
        return this;
    }

    public CompilationUnitBuilder setModifiers(Modifier ... modifiers) {
        return this.setModifiers(MoreLists.asImmutableList(modifiers));
    }

    public CompilationUnitBuilder setModifiers(List<Modifier> modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public CompilationUnitBuilder setTypeParameters(String ... parameters) {
        return this.setTypeParameters(Identifiers.newIdentifiers(parameters));
    }

    public CompilationUnitBuilder setTypeParameters(Identifier ... parameters) {
        return this.setTypeParameters(MoreLists.asImmutableList(parameters));
    }

    private CompilationUnitBuilder setTypeParameters(List<Identifier> parameters) {
        this.typeParameters = Optional.of(parameters);
        return this;
    }

    public CompilationUnitBuilder setTriggerTarget(String triggerTarget) {
        return this.setTarget(Identifiers.newIdentifier(triggerTarget));
    }

    public CompilationUnitBuilder setTarget(Identifier ... target) {
        this.triggerTarget = MoreLists.asImmutableList(target);
        return this;
    }

    public CompilationUnitBuilder setUsages(TriggerUsage ... usages) {
        this.usages = MoreLists.asImmutableList((Object[])usages);
        return this;
    }

    public CompilationUnitBuilder setBulk() {
        this.isBulk = true;
        return this;
    }

    public CompilationUnit buildClass() {
        return CompilationUnit._ClassDeclUnit(this.buildClassDecl());
    }

    public ClassDecl buildClassDecl() {
        return ClassDecl._ClassDecl(this.loc, this.modifiers, this.name, this.typeParameters, this.members, this.superTypeRef, this.interfaceRefs);
    }

    public CompilationUnit buildInterface() {
        return CompilationUnit._InterfaceDeclUnit(this.buildInterfaceDecl());
    }

    public InterfaceDecl buildInterfaceDecl() {
        return InterfaceDecl._InterfaceDecl(this.loc, this.modifiers, this.name, this.typeParameters, this.members, this.superTypeRef);
    }

    public CompilationUnit buildTrigger() {
        return CompilationUnit._TriggerDeclUnit(this.loc, this.name, this.triggerTarget, this.isBulk, this.usages, this.members);
    }

    public CompilationUnit buildEnum() {
        return CompilationUnit._EnumDeclUnit(this.buildEnumDecl());
    }

    public EnumDecl buildEnumDecl() {
        return EnumDecl._EnumDecl(this.loc, this.modifiers, this.name, this.enumMembers);
    }
}

