/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.ast;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.modelica.ast.ASTImportList;
import net.sourceforge.pmd.lang.modelica.ast.ASTName;
import net.sourceforge.pmd.lang.modelica.ast.ASTSimpleName;
import net.sourceforge.pmd.lang.modelica.ast.AbstractModelicaImportClause;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaParser;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaParserVisitor;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.InternalModelicaResolverApi;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

public final class ASTMultipleDefinitionImportClause
extends AbstractModelicaImportClause {
    private ASTName importFrom;
    private Set<String> importedNames = new HashSet<String>();

    ASTMultipleDefinitionImportClause(int id) {
        super(id);
    }

    ASTMultipleDefinitionImportClause(ModelicaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ModelicaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void jjtClose() {
        super.jjtClose();
        this.importFrom = (ASTName)this.getFirstChildOfType(ASTName.class);
        ASTImportList importList = (ASTImportList)this.getFirstChildOfType(ASTImportList.class);
        for (int i = 0; i < importList.getNumChildren(); ++i) {
            ASTSimpleName namePart = (ASTSimpleName)importList.getChild(i);
            this.importedNames.add(namePart.getImage());
        }
    }

    @Override
    protected ResolutionResult<ModelicaDeclaration> getCacheableImportSources(ResolutionState state, ModelicaScope scope) {
        return scope.safeResolveLexically(ModelicaDeclaration.class, state, this.importFrom.getCompositeName());
    }

    @Override
    protected void fetchImportedClassesFromSource(ResolutionContext result, ModelicaDeclaration source, String simpleName) throws Watchdog.CountdownException {
        if (this.importedNames.contains(simpleName)) {
            InternalModelicaResolverApi.resolveFurtherNameComponents(source, result, CompositeName.create(simpleName));
        }
    }

    @Override
    public boolean isQualified() {
        return true;
    }
}

