/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.internal.AstNodeOwner;
import net.sourceforge.pmd.lang.ast.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.ast.xpath.saxon.DocumentNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.ElementNode;
import net.sourceforge.pmd.lang.rule.xpath.AbstractXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.internal.RuleChainAnalyzer;
import net.sourceforge.pmd.lang.xpath.Initializer;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.DataMap;

@Deprecated
@InternalApi
public class SaxonXPathRuleQuery
extends AbstractXPathRuleQuery {
    static final String AST_ROOT = "_AST_ROOT_";
    private static final Logger LOG = Logger.getLogger(SaxonXPathRuleQuery.class.getName());
    private static final NamePool NAME_POOL = new NamePool();
    private static final DataMap.SimpleDataKey<DocumentNode> SAXON_TREE_CACHE_KEY = DataMap.simpleDataKey("saxon.tree");
    Map<String, List<Expression>> nodeNameToXPaths = new HashMap<String, List<Expression>>();
    XPathExpression xpathExpression;
    private List<XPathVariable> xpathVariables;
    private final DeprecatedAttrLogger attrCtx;

    @Deprecated
    public SaxonXPathRuleQuery() {
        this(DeprecatedAttrLogger.noop());
    }

    public SaxonXPathRuleQuery(DeprecatedAttrLogger attrCtx) {
        this.attrCtx = attrCtx;
    }

    @Override
    public boolean isSupportedVersion(String version) {
        return "1.0 compatibility".equals(version) || "2.0".equals(version);
    }

    @Override
    public List<Node> evaluate(Node node, RuleContext data) {
        this.initializeXPathExpression();
        try {
            DocumentNode documentNode = this.getDocumentNodeForRootNode(node);
            documentNode.setAttrCtx(this.attrCtx);
            ElementNode rootElementNode = documentNode.nodeToElementNode.get(node);
            assert (rootElementNode != null) : "Cannot find " + node;
            XPathDynamicContext xpathDynamicContext = this.createDynamicContext(rootElementNode);
            LinkedList<Node> results = new LinkedList<Node>();
            List<Expression> expressions = this.getXPathExpressionForNodeOrDefault(node.getXPathNodeName());
            for (Expression expression : expressions) {
                SequenceIterator iterator = expression.iterate(xpathDynamicContext.getXPathContextObject());
                Item current = iterator.next();
                while (current != null) {
                    if (!(current instanceof AstNodeOwner)) {
                        throw new RuntimeException("XPath rule expression returned a non-node (" + current.getClass() + "): " + current);
                    }
                    results.add(((AstNodeOwner)current).getUnderlyingNode());
                    current = iterator.next();
                }
            }
            Collections.sort(results, RuleChainAnalyzer.documentOrderComparator());
            return results;
        }
        catch (XPathException e) {
            throw new RuntimeException(this.xpath + " had problem: " + e.getMessage(), e);
        }
    }

    private List<Expression> getXPathExpressionForNodeOrDefault(String nodeName) {
        if (this.nodeNameToXPaths.containsKey(nodeName)) {
            return this.nodeNameToXPaths.get(nodeName);
        }
        return this.nodeNameToXPaths.get(AST_ROOT);
    }

    private XPathDynamicContext createDynamicContext(ElementNode elementNode) throws XPathException {
        XPathDynamicContext dynamicContext = this.xpathExpression.createDynamicContext((Item)elementNode);
        for (XPathVariable xpathVariable : this.xpathVariables) {
            String variableName = xpathVariable.getVariableQName().getLocalName();
            for (Map.Entry<PropertyDescriptor<?>, Object> entry : this.properties.entrySet()) {
                if (!variableName.equals(entry.getKey().name())) continue;
                ValueRepresentation valueRepresentation = SaxonXPathRuleQuery.getRepresentation(entry.getKey(), entry.getValue());
                dynamicContext.setVariable(xpathVariable, valueRepresentation);
            }
        }
        return dynamicContext;
    }

    @InternalApi
    public static ValueRepresentation getRepresentation(PropertyDescriptor<?> descriptor, Object value) {
        if (descriptor.isMultiValue()) {
            return SaxonXPathRuleQuery.getSequenceRepresentation((List)value);
        }
        return SaxonXPathRuleQuery.getAtomicRepresentation(value);
    }

    private DocumentNode getDocumentNodeForRootNode(Node node) {
        Node root = this.getRootNode(node);
        DataMap<DataMap.DataKey<?, ?>> userMap = root.getUserMap();
        DocumentNode docNode = (DocumentNode)userMap.get(SAXON_TREE_CACHE_KEY);
        if (docNode == null) {
            docNode = new DocumentNode(root, SaxonXPathRuleQuery.getNamePool());
            userMap.set(SAXON_TREE_CACHE_KEY, docNode);
        }
        return docNode;
    }

    private Node getRootNode(Node node) {
        Node root = node;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    private void addExpressionForNode(String nodeName, Expression expression) {
        if (!this.nodeNameToXPaths.containsKey(nodeName)) {
            this.nodeNameToXPaths.put(nodeName, new LinkedList());
        }
        this.nodeNameToXPaths.get(nodeName).add(expression);
    }

    private void initializeXPathExpression() {
        if (this.xpathExpression != null) {
            return;
        }
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator();
            XPathStaticContext xpathStaticContext = xpathEvaluator.getStaticContext();
            xpathStaticContext.getConfiguration().setNamePool(SaxonXPathRuleQuery.getNamePool());
            if ("1.0 compatibility".equals(this.version)) {
                ((AbstractStaticContext)xpathStaticContext).setBackwardsCompatibilityMode(true);
            }
            ((IndependentContext)xpathStaticContext).declareNamespace("fn", "http://www.w3.org/2005/xpath-functions");
            Initializer.initialize((IndependentContext)xpathStaticContext);
            this.xpathVariables = new ArrayList<XPathVariable>();
            for (PropertyDescriptor<?> propertyDescriptor : this.properties.keySet()) {
                String name = propertyDescriptor.name();
                if ("xpath".equals(name)) continue;
                XPathVariable xpathVariable = xpathStaticContext.declareVariable(null, name);
                this.xpathVariables.add(xpathVariable);
            }
            this.xpathExpression = xpathEvaluator.createExpression(this.xpath);
            this.analyzeXPathForRuleChain(xpathEvaluator);
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    private void analyzeXPathForRuleChain(XPathEvaluator xpathEvaluator) {
        Expression expr = this.xpathExpression.getInternalExpression();
        boolean useRuleChain = true;
        Iterable<Expression> subexpressions = RuleChainAnalyzer.splitUnions(expr);
        for (Expression subexpression : subexpressions) {
            RuleChainAnalyzer rca = new RuleChainAnalyzer(xpathEvaluator.getConfiguration());
            Expression modified = rca.visit(subexpression);
            if (rca.getRootElement() != null) {
                this.addExpressionForNode(rca.getRootElement(), modified);
                continue;
            }
            useRuleChain = false;
            break;
        }
        if (useRuleChain) {
            this.ruleChainVisits.addAll(this.nodeNameToXPaths.keySet());
        } else {
            this.nodeNameToXPaths.clear();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Unable to use RuleChain for XPath: " + this.xpath);
            }
        }
        this.addExpressionForNode(AST_ROOT, this.xpathExpression.getInternalExpression());
    }

    public static AtomicValue getAtomicRepresentation(Object value) {
        if (value == null) {
            return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
        }
        if (value instanceof Enum) {
            return new StringValue((CharSequence)value.toString());
        }
        if (value instanceof String) {
            return new StringValue((CharSequence)((String)value));
        }
        if (value instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)value));
        }
        if (value instanceof Integer) {
            return Int64Value.makeIntegerValue((long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BigIntegerValue(((Long)value).longValue());
        }
        if (value instanceof Double) {
            return new DoubleValue(((Double)value).doubleValue());
        }
        if (value instanceof Character) {
            return new StringValue((CharSequence)value.toString());
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Pattern) {
            return new StringValue((CharSequence)String.valueOf(value));
        }
        throw new RuntimeException("Unable to create ValueRepresentation for value of type: " + value.getClass());
    }

    public static Value getSequenceRepresentation(List<?> list) {
        if (list == null || list.isEmpty()) {
            return EmptySequence.getInstance();
        }
        Item[] converted = new Item[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            converted[i] = SaxonXPathRuleQuery.getAtomicRepresentation(list.get(i));
        }
        return new SequenceExtent(converted);
    }

    @Override
    public List<String> getRuleChainVisits() {
        this.initializeXPathExpression();
        return super.getRuleChainVisits();
    }

    public static NamePool getNamePool() {
        return NAME_POOL;
    }
}

