/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.diagnostics;

import apex.jorje.lsp.impl.diagnostics.CompilationExceptionDispatcher;
import apex.jorje.lsp.impl.diagnostics.DiagnosticCompilationExceptionVisitor;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.Lists;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;

class DiagnosticsUtil {
    private static final DiagnosticCompilationExceptionVisitor diagnosticVisitor = new DiagnosticCompilationExceptionVisitor();

    DiagnosticsUtil() {
    }

    static void clearDiagnostics(Provider<LanguageClient> languageClientProvider, String uri) {
        PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams();
        LanguageClient languageClient = (LanguageClient)languageClientProvider.get();
        diagnostics.setUri(uri);
        diagnostics.setDiagnostics(Collections.emptyList());
        languageClient.publishDiagnostics(diagnostics);
    }

    static void publishDiagnostics(Provider<LanguageClient> languageClientProvider, String uri, List<CompilationException> exceptions) {
        LanguageClient languageClient = (LanguageClient)languageClientProvider.get();
        languageClient.publishDiagnostics(DiagnosticsUtil.getDiagnosticsParams(uri, exceptions));
    }

    static PublishDiagnosticsParams getDiagnosticsParams(String uri, List<CompilationException> exceptions) {
        PublishDiagnosticsParams diagnosticsParams = new PublishDiagnosticsParams();
        ArrayList diagnostics = Lists.newArrayList();
        diagnosticsParams.setUri(uri);
        diagnostics.addAll(exceptions.stream().map(e -> CompilationExceptionDispatcher.dispatch(e, diagnosticVisitor)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        diagnosticsParams.setDiagnostics(diagnostics);
        return diagnosticsParams;
    }
}

