/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type;

import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.List;

class GenericTypeInfoDepthCalculator {
    GenericTypeInfoDepthCalculator() {
    }

    public static int calculate(TypeInfo type) {
        return GenericTypeInfoDepthCalculator.calculate(type.getTypeArguments(), 0);
    }

    public static int calculate(List<TypeInfo> types) {
        return GenericTypeInfoDepthCalculator.calculate(types, 0);
    }

    private static int calculate(List<TypeInfo> types, int startingValue) {
        if (startingValue >= GenericTypeInfo.MAX_SIZE) {
            return startingValue + 1;
        }
        if (types.isEmpty()) {
            return 0;
        }
        int max = 0;
        for (TypeInfo type : types) {
            int value = type.getTypeArguments().isEmpty() ? startingValue + 1 : GenericTypeInfoDepthCalculator.calculate(type.getTypeArguments(), startingValue + 1);
            max = Math.max(max, value);
        }
        return max;
    }
}

