/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ExtensionFunctionCall
extends FunctionCall {
    private transient AccessibleObject theMethod;
    private MethodRepresentation persistentMethod;
    private transient Class[] theParameterTypes;
    private PJConverter[] argumentConverters;
    private JPConverter resultConverter;
    private boolean checkForNodes;
    private Class theClass;

    public void init(StructuredQName functionName, Class theClass, AccessibleObject object, Configuration config) {
        this.setFunctionName(functionName);
        this.theClass = theClass;
        this.theMethod = object;
        this.theParameterTypes = null;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression tc = super.typeCheck(visitor, contextItemType);
        if (tc != this) {
            return tc;
        }
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        int firstParam = 0;
        int firstArg = 0;
        if (this.theMethod instanceof Constructor && this.theParameterTypes == null) {
            this.theParameterTypes = ((Constructor)this.theMethod).getParameterTypes();
        }
        if (this.theMethod instanceof Method) {
            boolean isStatic;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = ((Method)this.theMethod).getParameterTypes();
            }
            int n = firstArg = (isStatic = Modifier.isStatic(((Method)this.theMethod).getModifiers())) ? 0 : 1;
            boolean usesContext = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class;
            firstParam = usesContext ? 1 : 0;
        }
        this.argumentConverters = new PJConverter[this.argument.length];
        if (firstArg != 0) {
            SequenceType st = PJConverter.getEquivalentItemType(this.theClass);
            if (st != null) {
                RoleLocator role = new RoleLocator(0, this.getFunctionName(), 0);
                this.argument[0] = TypeChecker.staticTypeCheck(this.argument[0], st, false, role, visitor);
            }
            this.argumentConverters[0] = PJConverter.allocate(config, this.argument[0].getItemType(th), this.argument[0].getCardinality(), this.theClass);
        }
        int j = firstParam;
        for (int i = firstArg; i < this.argument.length; ++i) {
            SequenceType st = PJConverter.getEquivalentItemType(this.theParameterTypes[j]);
            if (st != null) {
                RoleLocator role = new RoleLocator(0, this.getFunctionName(), i);
                this.argument[i] = TypeChecker.staticTypeCheck(this.argument[i], st, false, role, visitor);
            }
            this.argumentConverters[i] = PJConverter.allocate(config, this.argument[i].getItemType(th), this.argument[i].getCardinality(), this.theParameterTypes[j]);
            ++j;
        }
        if (this.theMethod instanceof Constructor) {
            this.resultConverter = JPConverter.allocate(this.theClass, config);
        } else if (this.theMethod instanceof Method) {
            Class<?> resultClass = ((Method)this.theMethod).getReturnType();
            this.resultConverter = JPConverter.allocate(resultClass, config);
        } else if (this.theMethod instanceof Field) {
            Class<?> resultClass = ((Field)this.theMethod).getType();
            this.resultConverter = JPConverter.allocate(resultClass, config);
        } else {
            throw new AssertionError((Object)"Unknown component type");
        }
        ItemType resultType = this.resultConverter.getItemType();
        this.checkForNodes = resultType == AnyItemType.getInstance() || resultType instanceof NodeTest;
        this.resetLocalStaticProperties();
        return this;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public Expression copy() {
        throw new UnsupportedOperationException();
    }

    public int getIntrinsicDependencies() {
        Class<?>[] theParameterTypes;
        int depend = 0x1000000;
        if (this.theMethod instanceof Method && (theParameterTypes = ((Method)this.theMethod).getParameterTypes()).length > 0 && theParameterTypes[0] == XPathContext.class) {
            depend |= 0xE;
        }
        return depend;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ValueRepresentation[] argValues = new ValueRepresentation[this.argument.length];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = ExpressionTool.lazyEvaluate(this.argument[i], context, 1);
        }
        return this.call(argValues, context);
    }

    public Class getTargetClass() {
        return this.theClass;
    }

    public AccessibleObject getTargetMethod() {
        return this.theMethod;
    }

    public Class[] getParameterTypes() {
        return this.theParameterTypes;
    }

    protected SequenceIterator call(ValueRepresentation[] argValues, XPathContext context) throws XPathException {
        if (this.theMethod instanceof Constructor) {
            Constructor constructor = (Constructor)this.theMethod;
            if (this.theParameterTypes == null) {
                this.theParameterTypes = constructor.getParameterTypes();
            }
            Object[] params = new Object[this.theParameterTypes.length];
            this.setupParams(argValues, params, this.theParameterTypes, 0, 0, context);
            try {
                Object result = this.invokeConstructor(constructor, params);
                return this.asIterator(result, context);
            }
            catch (InstantiationException err0) {
                throw new XPathException("Cannot instantiate class", err0);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Constructor access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
            catch (NullPointerException err2) {
                throw new XPathException("Object is null");
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw (XPathException)ex;
                }
                if (context.getController().isTracing() || context.getConfiguration().isTraceExternalFunctions()) {
                    err3.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function: " + err3.getTargetException().toString(), ex);
            }
        }
        if (this.theMethod instanceof Method) {
            Object theInstance;
            boolean usesContext;
            Method method = (Method)this.theMethod;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if (this.theParameterTypes == null) {
                this.theParameterTypes = method.getParameterTypes();
            }
            boolean bl = this.theParameterTypes.length > 0 && this.theParameterTypes[0] == XPathContext.class ? true : (usesContext = false);
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function");
                }
                theInstance = this.getTargetInstance(argValues[0], context);
            }
            Object[] params = new Object[this.theParameterTypes.length];
            if (usesContext) {
                params[0] = context;
            }
            this.setupParams(argValues, params, this.theParameterTypes, usesContext ? 1 : 0, isStatic ? 0 : 1, context);
            try {
                Object result = this.invokeMethod(method, theInstance, params);
                if (method.getReturnType() == Void.TYPE) {
                    return EmptyIterator.getInstance();
                }
                return this.asIterator(result, context);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Method access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
            catch (NullPointerException err2) {
                throw new XPathException("Object is null", err2);
            }
            catch (InvocationTargetException err3) {
                Throwable ex = err3.getTargetException();
                if (ex instanceof XPathException) {
                    throw (XPathException)ex;
                }
                if (context.getController().isTracing() || context.getConfiguration().isTraceExternalFunctions()) {
                    err3.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function " + err3.getTargetException().toString(), ex);
            }
        }
        if (this.theMethod instanceof Field) {
            Object theInstance;
            Field field = (Field)this.theMethod;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                theInstance = null;
            } else {
                if (argValues.length == 0) {
                    throw new XPathException("Must supply an argument for a non-static extension function");
                }
                theInstance = this.getTargetInstance(argValues[0], context);
            }
            try {
                Object result = this.getField(field, theInstance);
                return this.asIterator(result, context);
            }
            catch (IllegalAccessException err1) {
                throw new XPathException("Field access is illegal", err1);
            }
            catch (IllegalArgumentException err2) {
                throw new XPathException("Argument is of wrong type", err2);
            }
        }
        throw new AssertionError((Object)("property " + this.theMethod + " is neither constructor, method, nor field"));
    }

    private Object getTargetInstance(ValueRepresentation arg0, XPathContext context) throws XPathException {
        Value val = Value.asValue(arg0).reduce();
        PJConverter converter = this.argumentConverters[0];
        return converter.convert(val, this.theClass, context);
    }

    private SequenceIterator asIterator(Object result, XPathContext context) throws XPathException {
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        SequenceIterator resultIterator = result instanceof SequenceIterator ? (SequenceIterator)result : Value.asIterator(this.resultConverter.convert(result, context));
        if (this.checkForNodes) {
            return new ItemMappingIterator(resultIterator, new ConfigurationCheckingFunction(context.getConfiguration()));
        }
        return resultIterator;
    }

    private void setupParams(ValueRepresentation[] argValues, Object[] params, Class[] paramTypes, int firstParam, int firstArg, XPathContext context) throws XPathException {
        int j = firstParam;
        for (int i = firstArg; i < argValues.length; ++i) {
            ValueRepresentation val = argValues[i];
            if (val instanceof Value) {
                val = ((Value)val).reduce();
            }
            params[j] = this.argumentConverters[i].convert(val, paramTypes[j], context);
            ++j;
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.resultConverter == null) {
            return AnyItemType.getInstance();
        }
        return this.resultConverter.getItemType();
    }

    public int computeCardinality() {
        Class resultClass = this.getReturnClass();
        if (resultClass.equals(Void.TYPE)) {
            return 24576;
        }
        if (this.resultConverter == null) {
            return 57344;
        }
        return this.resultConverter.getCardinality();
    }

    public Class getReturnClass() {
        if (this.theMethod instanceof Method) {
            return ((Method)this.theMethod).getReturnType();
        }
        if (this.theMethod instanceof Field) {
            return ((Field)this.theMethod).getType();
        }
        if (this.theMethod instanceof Constructor) {
            return this.theClass;
        }
        return null;
    }

    public PJConverter[] getArgumentConverters() {
        return this.argumentConverters;
    }

    public JPConverter getResultConverter() {
        return this.resultConverter;
    }

    protected Object invokeConstructor(Constructor constructor, Object[] params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return constructor.newInstance(params);
    }

    protected Object invokeMethod(Method method, Object instance, Object[] params) throws IllegalAccessException, InvocationTargetException {
        return method.invoke(instance, params);
    }

    protected Object getField(Field field, Object instance) throws IllegalAccessException {
        return field.get(instance);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.persistentMethod = new MethodRepresentation(this.theClass, this.theMethod);
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
            this.theMethod = this.persistentMethod.recoverAccessibleObject();
            this.theParameterTypes = null;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Cannot load a class containing extension functions used by the stylesheet: " + cnfe.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Failed to read compiled representation of extension function call to " + (this.theClass == null ? "*unknown class*" : this.theClass.getClass().getName()) + ": " + e.getMessage());
        }
    }

    public static String toCamelCase(String name, boolean debug, PrintStream diag) {
        if (name.indexOf(45) >= 0) {
            FastStringBuffer buff = new FastStringBuffer(name.length());
            boolean afterHyphen = false;
            for (int n = 0; n < name.length(); ++n) {
                char c = name.charAt(n);
                if (c == '-') {
                    afterHyphen = true;
                    continue;
                }
                if (afterHyphen) {
                    buff.append(Character.toUpperCase(c));
                } else {
                    buff.append(c);
                }
                afterHyphen = false;
            }
            name = buff.toString();
            if (debug) {
                diag.println("Seeking a method with adjusted name " + name);
            }
        }
        return name;
    }

    private static class ConfigurationCheckingFunction
    implements ItemMappingFunction {
        private Configuration config;

        public ConfigurationCheckingFunction(Configuration config) {
            this.config = config;
        }

        public Item map(Item item) throws XPathException {
            if (item instanceof NodeInfo && !this.config.isCompatible(((NodeInfo)item).getConfiguration())) {
                throw new XPathException("NodeInfo returned by extension function was created with an incompatible Configuration");
            }
            return item;
        }
    }

    private static class MethodRepresentation
    implements Serializable {
        private Class theClass;
        private byte category;
        private String name;
        private Class[] params;

        public MethodRepresentation(Class theClass, AccessibleObject obj) {
            this.theClass = theClass;
            if (obj instanceof Method) {
                this.category = 0;
                this.name = ((Method)obj).getName();
                this.params = ((Method)obj).getParameterTypes();
            } else if (obj instanceof Constructor) {
                this.category = 1;
                this.params = ((Constructor)obj).getParameterTypes();
            } else {
                this.category = (byte)2;
                this.name = ((Field)obj).getName();
            }
        }

        public AccessibleObject recoverAccessibleObject() throws NoSuchMethodException, NoSuchFieldException {
            switch (this.category) {
                case 0: {
                    return this.theClass.getMethod(this.name, this.params);
                }
                case 1: {
                    return this.theClass.getConstructor(this.params);
                }
                case 2: {
                    return this.theClass.getField(this.name);
                }
            }
            return null;
        }
    }
}

