/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.LoopStack;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.ExpressionUtil;
import apex.jorje.semantic.ast.expression.TopLevel;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.ForLoopInitFactory;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import java.util.List;
import org.objectweb.asm.Label;

public class ForLoopStatement
extends Statement {
    private final List<Statement> inits;
    private final Location loc;
    private final Condition condition;
    private final Expression control;
    private final Statement bodyStatement;
    private final LocalVariableScope locals;

    public ForLoopStatement(AstNode definingNode, Stmnt.ForLoop stmnt, ForControl.CStyleForControl forControl) {
        super(definingNode);
        this.loc = stmnt.loc;
        this.inits = ForLoopInitFactory.create(this, stmnt.loc, forControl.inits);
        this.condition = forControl.condition.map(value -> new StandardCondition(this, (Expr)value)).orElse(Condition.NOOP);
        this.control = forControl.control.map(value -> {
            Expression control = AstNodes.get().create((AstNode)this, (Expr)value);
            if (TopLevel.canBeTopLevel(value)) {
                control.setTopLevel();
            }
            return control;
        }).orElse(Expression.NOOP);
        this.bodyStatement = BlockStatement.builder().setDefiningNode(this).setStmnt(stmnt.stmnt).build();
        this.locals = new LocalVariableScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                for (Statement init : this.inits) {
                    init.traverse(visitor, scope);
                }
                this.condition.traverse(visitor, scope);
                this.control.traverse(visitor, scope);
                this.bodyStatement.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            for (Statement init : this.inits) {
                init.validate(symbols, scope);
            }
            this.condition.validate(symbols, scope);
            this.control.validate(symbols, scope);
            this.bodyStatement.validate(symbols, scope);
            Errors errors = scope.getErrors();
            if (errors.isInvalid(this.inits) || errors.isInvalid(this.condition, this.condition, this.bodyStatement)) {
                errors.markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        LoopStack loopStack = emitter.getLoopStack();
        LoopStack.LoopContext loop = new LoopStack.LoopContext(emitter, this.bodyStatement.getLoc(), this.getLoc());
        loop.setTryStackSize();
        loopStack.push(loop);
        loop.emitIterationCounter();
        for (Statement init : this.inits) {
            init.emit(emitter);
        }
        Label start = new Label();
        emitter.emit(start);
        Label falseLabel = this.condition.getFalseLabel(emitter);
        loop.emitIterationCounterIncrement();
        this.bodyStatement.emit(emitter);
        loop.emitContinueLabel();
        if (!ExpressionUtil.isLiteralExpression(this.control)) {
            this.control.emit(emitter);
            if (!this.control.isTopLevel() && this.control != Expression.NOOP) {
                emitter.emit(this.control.getLoc(), 87);
            }
        }
        emitter.emitJump(this.condition.getLoc(), 167, start);
        if (falseLabel != null) {
            emitter.emit(falseLabel);
        }
        LoopStack.LoopContext sanity = loopStack.pop();
        assert (loop == sanity);
        loop.emitZeroIterationCounter();
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    @SfdcCalled
    public Expression getControl() {
        return this.control;
    }

    public Statement getBody() {
        return this.bodyStatement;
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }
}

