/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.common.tuple.BooleanHolder;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.TypedExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.UntypedExternalDependency;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.matchers.IsTypeWithApexName;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;

public class IsTypedExternalDependency
extends TypeSafeDiagnosingMatcher<ExternalDependency> {
    private final Optional<Matcher<TypeInfo>> typeInfoMatcher;
    private final Optional<Matcher<Variable>> variableMatcher;
    private final Optional<Matcher<DmlOperation>> dmlOperationMatcher;
    private final Optional<Matcher<Boolean>> foreignKeyReferencedMatcher;
    private final Optional<Matcher<Boolean>> isLastMatcher;

    private IsTypedExternalDependency(Builder builder) {
        this.typeInfoMatcher = builder.typeInfoMatcher;
        this.variableMatcher = builder.variableMatcher;
        this.dmlOperationMatcher = builder.dmlOperationMatcher;
        this.foreignKeyReferencedMatcher = builder.foreignKeyReferencedMatcher;
        this.isLastMatcher = builder.isLastMatcher;
    }

    public static Builder matching() {
        return new Builder();
    }

    private static FeatureMatcher<Variable, String> hasBytecodeName(Matcher<String> matcher) {
        return new FeatureMatcher<Variable, String>(matcher, "name", "name"){

            protected String featureValueOf(Variable actual) {
                return actual.getName();
            }
        };
    }

    public void describeTo(Description description) {
        this.typeInfoMatcher.ifPresent(matcher -> {
            description.appendText("type info: ");
            matcher.describeTo(description);
        });
        this.variableMatcher.ifPresent(matcher -> {
            description.appendText("\nvariable name: ");
            matcher.describeTo(description);
        });
        this.dmlOperationMatcher.ifPresent(matcher -> {
            description.appendText("\ndml op: ");
            matcher.describeTo(description);
        });
        this.foreignKeyReferencedMatcher.ifPresent(matcher -> {
            description.appendText("\nisReferencedViaForeignKey: ");
            matcher.describeTo(description);
        });
        this.isLastMatcher.ifPresent(matcher -> {
            description.appendText("\nisLast: ");
            matcher.describeTo(description);
        });
    }

    protected boolean matchesSafely(ExternalDependency externalDependency, final Description description) {
        return externalDependency.accept(new ExternalDependency.ExternalDependencyVisitor<Boolean>(){

            @Override
            public Boolean visit(TypedExternalDependency dependency) {
                BooleanHolder matches = new BooleanHolder(true);
                IsTypedExternalDependency.this.typeInfoMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getTypeInfo())) {
                        description.appendText("type info: ");
                        matcher.describeMismatch((Object)dependency.getTypeInfo(), description);
                        matches.value = false;
                    }
                });
                IsTypedExternalDependency.this.variableMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getReferenceInfo().getVariable())) {
                        description.appendText("\nvariable name: ");
                        matcher.describeMismatch((Object)dependency.getReferenceInfo().getVariable(), description);
                        matches.value = false;
                    }
                });
                IsTypedExternalDependency.this.dmlOperationMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getReferenceInfo().getDmlOperation())) {
                        description.appendText("\ndml op: ");
                        matcher.describeMismatch((Object)dependency.getReferenceInfo().getDmlOperation(), description);
                        matches.value = false;
                    }
                });
                IsTypedExternalDependency.this.foreignKeyReferencedMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getReferenceInfo().isReferencedViaForeignKey())) {
                        description.appendText("\nisReferencedViaForeignKey: ");
                        matcher.describeMismatch((Object)dependency.getReferenceInfo().isReferencedViaForeignKey(), description);
                        matches.value = false;
                    }
                });
                IsTypedExternalDependency.this.isLastMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getReferenceInfo().isLast())) {
                        description.appendText("\nisLast: ");
                        matcher.describeMismatch((Object)dependency.getReferenceInfo().isLast(), description);
                        matches.value = false;
                    }
                });
                return matches.value;
            }

            @Override
            public Boolean visit(UntypedExternalDependency dependency) {
                description.appendText("UntypedExternalDependency");
                return false;
            }
        });
    }

    public static class Builder {
        private Optional<Matcher<TypeInfo>> typeInfoMatcher = Optional.empty();
        private Optional<Matcher<Variable>> variableMatcher = Optional.empty();
        private Optional<Matcher<DmlOperation>> dmlOperationMatcher = Optional.empty();
        private Optional<Matcher<Boolean>> foreignKeyReferencedMatcher = Optional.empty();
        private Optional<Matcher<Boolean>> isLastMatcher = Optional.empty();

        private Builder() {
        }

        public Builder withTypeName(String apexName) {
            this.typeInfoMatcher = Optional.of(IsTypeWithApexName.hasApexName(apexName));
            return this;
        }

        public Builder withDmlOperation(DmlOperation dmlOperation) {
            this.dmlOperationMatcher = Optional.of(Is.is((Object)((Object)dmlOperation)));
            return this;
        }

        public Builder withFieldName(String variableName) {
            this.variableMatcher = Optional.of(IsTypedExternalDependency.hasBytecodeName((Matcher<String>)Matchers.equalTo((Object)variableName)));
            return this;
        }

        public Builder withReferenceViaForeignKey() {
            this.foreignKeyReferencedMatcher = Optional.of(Is.is((Object)true));
            return this;
        }

        public Builder withNonReferenceViaForeignKey() {
            this.foreignKeyReferencedMatcher = Optional.of(Is.is((Object)false));
            return this;
        }

        public Builder withIsLast() {
            this.isLastMatcher = Optional.of(Is.is((Object)true));
            return this;
        }

        public Builder withNotLast() {
            this.isLastMatcher = Optional.of(Is.is((Object)false));
            return this;
        }

        public IsTypedExternalDependency build() {
            return new IsTypedExternalDependency(this);
        }
    }
}

