/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.method;

import apex.common.base.Result;
import apex.common.collect.MoreCollections;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.member.method.MemoizingMethodTable;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.member.method.MethodTable;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.method.signature.Signature;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import java.util.Collection;
import java.util.List;

public class MultipleMethodTable
extends MemoizingMethodTable {
    private final MethodTable nonStaticTable = new StandardMethodTable();
    private final MethodTable staticTable = new StandardMethodTable();

    @Override
    public Result<MethodInfo> getApproximate(TypeInfo referencingType, String methodName, List<TypeInfo> parameterTypes, MethodLookupMode mode) {
        switch (mode) {
            case STATICS: {
                Result<MethodInfo> method = this.staticTable.getApproximate(referencingType, methodName, parameterTypes, MethodLookupMode.STATICS);
                return method.hasResult() ? method : this.nonStaticTable.getApproximate(referencingType, methodName, parameterTypes, MethodLookupMode.INSTANCE);
            }
            case CONSTRUCTORS: {
                return this.nonStaticTable.getApproximate(referencingType, methodName, parameterTypes, MethodLookupMode.CONSTRUCTORS);
            }
            case INSTANCE: {
                Result<MethodInfo> method = this.nonStaticTable.getApproximate(referencingType, methodName, parameterTypes, MethodLookupMode.INSTANCE);
                return method.hasResult() ? method : this.staticTable.getApproximate(referencingType, methodName, parameterTypes, MethodLookupMode.STATICS);
            }
        }
        throw new UnexpectedCodePathException("unexpected mode: " + (Object)((Object)mode));
    }

    @Override
    public MethodInfo get(Signature signature) {
        MethodInfo method = this.nonStaticTable.get(signature);
        return method == null ? this.staticTable.get(signature) : method;
    }

    @Override
    public MethodInfo remove(Signature signature) {
        MethodInfo method = this.nonStaticTable.remove(signature);
        return method == null ? this.staticTable.remove(signature) : method;
    }

    @Override
    public Result<Void> addNoDuplicatesAllowed(MethodInfo method) {
        return method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.staticTable.addNoDuplicatesAllowed(method) : this.nonStaticTable.addNoDuplicatesAllowed(method);
    }

    @Override
    public Result<Void> addDuplicatesAllowed(MethodInfo method) {
        return method.getModifiers().has(ModifierTypeInfos.STATIC) ? this.staticTable.addDuplicatesAllowed(method) : this.nonStaticTable.addDuplicatesAllowed(method);
    }

    @Override
    public MethodTable resolve() {
        this.staticTable.resolve();
        this.nonStaticTable.resolve();
        return this;
    }

    @Override
    public boolean isResolved() {
        return this.staticTable.isResolved() || this.nonStaticTable.isResolved();
    }

    @Override
    public Collection<MethodInfo> all() {
        return MoreCollections.concatCollections(this.staticTable.all(), this.nonStaticTable.all());
    }
}

