/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.Query;
import apex.jorje.data.soql.QueryExpr;
import apex.jorje.data.soql.QueryOp;
import apex.jorje.data.soql.WhereCalcOp;
import apex.jorje.data.soql.WhereCompoundOp;
import apex.jorje.data.soql.WhereExpr;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.soql.DistanceFunctionExprPrinter;
import apex.jorje.services.printers.soql.FieldIdentifierPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;
import apex.jorje.services.printers.soql.QueryExprPrinter;
import apex.jorje.services.printers.soql.QueryOpPrinter;
import apex.jorje.services.printers.soql.QueryPrinter;
import com.google.common.base.Supplier;
import java.util.List;

public class WhereExprPrinter
implements Printer<WhereExpr> {
    private static final Printer<WhereExpr> INSTANCE = new WhereExprPrinter(QueryPrinter.get(), FieldPrinter.get(), FieldIdentifierPrinter.get(), QueryExprPrinter.get(), QueryOpPrinter.get(), DistanceFunctionExprPrinter.get());
    private static final WhereCalcOp.MatchBlock<String> WHERE_CALC_OP = new WhereCalcOp.MatchBlock<String>(){

        @Override
        public String _case(WhereCalcOp.WhereCalcPlus x) {
            return "+";
        }

        @Override
        public String _case(WhereCalcOp.WhereCalcMinus x) {
            return "-";
        }
    };
    private final Supplier<Printer<Query>> queryPrinter;
    private final Printer<FieldIdentifier> fieldIdentifierPrinter;
    private final Printer<QueryOp> queryOpPrinter;
    private final Printer<List<QueryExpr>> listQueryExpr;
    private final Printer<QueryExpr> queryExprPrinter;
    private final Printer<DistanceFunctionExpr> distanceFunctionExprPrinter;
    private final WhereCompoundOp.MatchBlock<Printer<List<WhereExpr>>> whereCompoundPrinter;
    private final Printer<Field> fieldPrinter;

    private WhereExprPrinter(Supplier<Printer<Query>> queryPrinter, Printer<Field> fieldPrinter, Printer<FieldIdentifier> fieldIdentifierPrinter, Printer<QueryExpr> queryExprPrinter, Printer<QueryOp> queryOpPrinter, Printer<DistanceFunctionExpr> distanceFunctionExprPrinter) {
        this.queryPrinter = queryPrinter;
        this.fieldPrinter = fieldPrinter;
        this.fieldIdentifierPrinter = fieldIdentifierPrinter;
        this.queryExprPrinter = queryExprPrinter;
        this.queryOpPrinter = queryOpPrinter;
        this.distanceFunctionExprPrinter = distanceFunctionExprPrinter;
        this.listQueryExpr = ListPrinter.create(queryExprPrinter, ", ", "(", ")");
        final Printer<List<WhereExpr>> listAndExpr = ListPrinter.create(this, " AND ", "(", ")");
        final Printer<List<WhereExpr>> listOrExpr = ListPrinter.create(this, " OR ", "(", ")");
        this.whereCompoundPrinter = new WhereCompoundOp.MatchBlock<Printer<List<WhereExpr>>>(){

            @Override
            public Printer<List<WhereExpr>> _case(WhereCompoundOp.QueryAnd x) {
                return listAndExpr;
            }

            @Override
            public Printer<List<WhereExpr>> _case(WhereCompoundOp.QueryOr x) {
                return listOrExpr;
            }
        };
    }

    public static Printer<WhereExpr> get() {
        return INSTANCE;
    }

    @Override
    public String print(WhereExpr x, final PrintContext ctx) {
        return x.match(new WhereExpr.MatchBlock<String>(){

            @Override
            public String _case(WhereExpr.WhereCalcExpr x) {
                String calc = (String)x.calc.match(WHERE_CALC_OP);
                return WhereExprPrinter.this.fieldIdentifierPrinter.print(x.field1, ctx) + " " + calc + " " + WhereExprPrinter.this.fieldIdentifierPrinter.print(x.field2, ctx) + " " + WhereExprPrinter.this.queryOpPrinter.print(x.op, ctx) + " " + WhereExprPrinter.this.queryExprPrinter.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereDistanceExpr x) {
                return WhereExprPrinter.this.distanceFunctionExprPrinter.print(x.distance, ctx) + " " + WhereExprPrinter.this.queryOpPrinter.print(x.op, ctx) + " " + WhereExprPrinter.this.queryExprPrinter.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereOpExpr x) {
                return WhereExprPrinter.this.fieldPrinter.print(x.field, ctx) + " " + WhereExprPrinter.this.queryOpPrinter.print(x.op, ctx) + " " + WhereExprPrinter.this.queryExprPrinter.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereOpExprs x) {
                return WhereExprPrinter.this.fieldPrinter.print(x.field, ctx) + " " + WhereExprPrinter.this.queryOpPrinter.print(x.op, ctx) + " " + WhereExprPrinter.this.listQueryExpr.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereInnerExpr x) {
                return WhereExprPrinter.this.fieldPrinter.print(x.field, ctx) + " " + WhereExprPrinter.this.queryOpPrinter.print(x.op, ctx) + " (" + ((Printer)WhereExprPrinter.this.queryPrinter.get()).print(x.inner, ctx) + ")";
            }

            @Override
            public String _case(WhereExpr.WhereCompoundExpr x) {
                return ((Printer)x.op.match(WhereExprPrinter.this.whereCompoundPrinter)).print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereUnaryExpr x) {
                return "(NOT " + WhereExprPrinter.this.print(x.expr, ctx) + ")";
            }
        });
    }
}

