/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.property.rule;

import apex.common.collect.MoreCollections;
import apex.jorje.semantic.ast.modifier.AnnotationParameter;
import apex.jorje.semantic.ast.modifier.property.rule.AnnotationPropertyRule;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreSets;
import java.util.Collection;
import java.util.Set;

public class AnnotationPropertyRuleGroup {
    public static final AnnotationPropertyRuleGroup NONE = AnnotationPropertyRuleGroup.builder().build();
    private final Set<AnnotationPropertyRule> softRules;
    private final Set<AnnotationPropertyRule> hardRules;

    private AnnotationPropertyRuleGroup(Builder builder) {
        this.hardRules = builder.hardRules;
        this.softRules = builder.softRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(AnnotationContext context, AnnotationParameter parameter) {
        for (AnnotationPropertyRule hardRule : this.hardRules) {
            hardRule.validate(context, parameter);
            if (!context.getErrors().isInvalid(parameter)) continue;
            return;
        }
        for (AnnotationPropertyRule rule : this.softRules) {
            rule.validate(context, parameter);
        }
    }

    public Collection<AnnotationPropertyRule> getRules() {
        return MoreCollections.concatCollections(this.hardRules, this.softRules);
    }

    public static class Builder {
        private Set<AnnotationPropertyRule> softRules = ImmutableSet.of();
        private Set<AnnotationPropertyRule> hardRules = ImmutableSet.of();

        private Builder() {
        }

        public Builder addHardRules(AnnotationPropertyRule ... hardRules) {
            this.hardRules = ImmutableSet.copyOf(MoreSets.newLinkedHashSet(hardRules));
            return this;
        }

        public Builder addSoftRules(AnnotationPropertyRule ... softRules) {
            this.softRules = ImmutableSet.copyOf(MoreSets.newLinkedHashSet(softRules));
            return this;
        }

        public AnnotationPropertyRuleGroup build() {
            return new AnnotationPropertyRuleGroup(this);
        }
    }
}

