/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.Location;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.collections.Sets;

public class NamesCompletionStrategies {
    private static final Logger logger = LoggerFactory.getLogger(NamesCompletionStrategies.class);

    public static List<CompletionItem> provideCompletions(TextDocumentPositionParams params, ApexDocumentService documentService, ApexCompilerService compilerService, CompletionActivationFactory factory, NameProcessor processor) {
        Optional<Document> optDoc = documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            if (strategy.shouldSuggestTopLevel()) {
                CodeUnit codeUnit = compilerService.compile((Document)doc);
                Compilation compilation = codeUnit.getNode();
                TypeInfo compiledType = compilation.getDefiningType();
                processor.processClass(compiledType, items);
                try {
                    int lineOffset = doc.getLineOffset(params.getPosition().getLine());
                    int offset = lineOffset + params.getPosition().getCharacter();
                    UserClassVisitor userClassVisitor = new UserClassVisitor(offset);
                    codeUnit.additionalValidate(userClassVisitor);
                    Collection<UserClass> innerClasses = userClassVisitor.getInnerClasses();
                    for (UserClass innerClass : innerClasses) {
                        processor.processClass(innerClass.getDefiningType(), items);
                    }
                }
                catch (BadLocationException e) {
                    logger.error("Encountered a bad location while providing completion", (Throwable)e);
                }
            }
        });
        return NamesCompletionStrategies.dedup(items);
    }

    public static boolean isImplicitInit(MethodInfo methodInfo) {
        String canonicalName = methodInfo.getCanonicalName();
        return Objects.equals(canonicalName, "<init>") || Objects.equals(canonicalName, "<clinit>");
    }

    public static boolean isBaseMethod(MethodInfo methodInfo) {
        return methodInfo.getDefiningType().getApexName().equalsIgnoreCase("System.ApexBaseClass");
    }

    public static boolean isObjectMethod(MethodInfo methodInfo) {
        return methodInfo.getDefiningType().getApexName().equalsIgnoreCase("Object");
    }

    public static boolean isCloneMethod(MethodInfo methodInfo, TypeInfo definingType) {
        return methodInfo.getCanonicalName().equalsIgnoreCase("clone") && !(definingType instanceof SObjectTypeInfo);
    }

    public static boolean isFilteredOutMethod(MethodInfo methodInfo, TypeInfo definingType) {
        return NamesCompletionStrategies.isImplicitInit(methodInfo) || NamesCompletionStrategies.isBaseMethod(methodInfo) || NamesCompletionStrategies.isObjectMethod(methodInfo) || NamesCompletionStrategies.isCloneMethod(methodInfo, definingType);
    }

    public static boolean isOverridableMethod(MethodInfo methodInfo) {
        return methodInfo.getModifiers().has(ModifierTypeInfos.VIRTUAL) || methodInfo.getModifiers().has(ModifierTypeInfos.ABSTRACT);
    }

    private static List<CompletionItem> dedup(List<CompletionItem> items) {
        return items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CompletionItem>(Comparator.comparing(CompletionItem::getLabel))), ArrayList::new));
    }

    private static final class UserClassVisitor
    extends AstVisitor<AdditionalPassScope> {
        final Set<UserClass> userClasses = Sets.newHashSet();
        private final int activationOffset;

        UserClassVisitor(int activationOffset) {
            this.activationOffset = activationOffset;
        }

        public Collection<UserClass> getInnerClasses() {
            return this.userClasses;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(UserClass node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (this.isActivationWithinNodeContext(node.getBodyLoc()) && !TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                this.userClasses.add(node);
            }
        }

        private boolean isActivationWithinNodeContext(Location loc) {
            int startIndex = loc.getStartIndex();
            int endIndex = loc.getEndIndex();
            return this.activationOffset >= startIndex && endIndex >= this.activationOffset;
        }
    }

    public static interface NameProcessor {
        public void processClass(TypeInfo var1, List<CompletionItem> var2);
    }
}

