/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import apex.common.collect.CaseInsensitiveMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinkedCaseInsensitiveMap<V>
extends LinkedHashMap<String, V> {
    private static final long serialVersionUID = -760624958238808960L;
    private final Map<String, String> caseInsensitiveKeys = new CaseInsensitiveMap<String>();

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.caseInsensitiveKeys.containsKey(key);
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this.caseInsensitiveKeys.put(key, key);
        if (oldKey != null) {
            super.remove(oldKey);
        }
        return super.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return key instanceof String ? (V)super.remove(this.caseInsensitiveKeys.remove(key)) : null;
    }

    @Override
    public V get(Object key) {
        return key instanceof String ? (V)super.get(this.caseInsensitiveKeys.get(key)) : null;
    }

    @Override
    public void clear() {
        this.caseInsensitiveKeys.clear();
        super.clear();
    }
}

