/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.base.Result;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.common.StandardI18nSupplier;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.MethodLookupMode;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.type.AnnotationTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.parent.ParentTableFactory;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MoreSets;
import java.util.List;

class InterfaceImplementationValidator {
    private static final InterfaceImplementationValidator INSTANCE = new InterfaceImplementationValidator();

    private InterfaceImplementationValidator() {
    }

    static InterfaceImplementationValidator get() {
        return INSTANCE;
    }

    HashMultimap<MethodInfo, MethodInfo> validateInterfaceImplementations(UserClass userClass, SymbolScope scope) {
        HashMultimap<MethodInfo, MethodInfo> implementations = HashMultimap.create();
        TypeInfo definingType = userClass.getDefiningType();
        boolean isAbstract = definingType.getModifiers().has(ModifierTypeInfos.ABSTRACT);
        for (TypeInfo _interface : ParentTableFactory.getVersionedInterfaces(definingType, definingType)) {
            boolean isVisible = Visibility.isTypeVisible(scope.getSymbols().getAccessEvaluator(), definingType, _interface, Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES);
            if (!isVisible) continue;
            for (MethodInfo methodInterface : _interface.methods().getInstance()) {
                Result<MethodInfo> result = this.getApproximate(definingType, methodInterface.getSignature().getName(), methodInterface.getSignature().getParameterTypes());
                if (result.hasError() || result.absent()) {
                    if (isAbstract) continue;
                    scope.getErrors().addIfError((AstNode)userClass, result, StandardI18nSupplier.create("interface.implementation.missing.method", definingType, methodInterface));
                    continue;
                }
                MethodInfo methodImpl = result.get();
                if (!Distance.get().canAssign(definingType, methodImpl.getReturnType(), methodInterface.getReturnType()) && !isAbstract) {
                    scope.getErrors().markInvalid((AstNode)userClass, I18nSupport.getLabel("interface.implementation.missing.method", definingType, methodInterface));
                    continue;
                }
                if (!isAbstract) {
                    if (methodImpl.getModifiers().none(ModifierTypeInfos.GLOBAL, ModifierTypeInfos.PUBLIC)) {
                        scope.getErrors().markInvalid((AstNode)userClass, I18nSupport.getLabel("interface.implementation.method.not.visible", definingType, methodInterface, _interface));
                    }
                    if (methodImpl.getModifiers().has(AnnotationTypeInfos.DEPRECATED)) {
                        scope.getErrors().markInvalid((AstNode)userClass, I18nSupport.getLabel("interface.implementation.method.deprecated", methodInterface));
                    }
                }
                implementations.put((Object)methodImpl, (Object)methodInterface);
            }
        }
        for (MethodInfo methodImpl : implementations.keys()) {
            methodImpl.setMethodInterfaces(MoreSets.toImmutableSet(implementations.get((Object)methodImpl)));
        }
        return implementations;
    }

    private Result<MethodInfo> getApproximate(TypeInfo type, String methodName, List<TypeInfo> parameterTypes) {
        Result<MethodInfo> result = type.virtualMethods().getApproximate(type, methodName, parameterTypes, MethodLookupMode.INSTANCE);
        return result.hasResult() ? result : type.methods().getApproximate(type, methodName, parameterTypes, MethodLookupMode.STATICS);
    }
}

