/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.data.ast.Expr;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.services.printers.PrintContext;
import java.util.ArrayList;
import java.util.List;

public final class PrintContexts {
    private PrintContexts() {
    }

    public static PrintContext empty() {
        return Empty.INSTANCE;
    }

    public static PrintContext standard() {
        return new Standard();
    }

    private static class Standard
    implements PrintContext {
        private final List<PrintContext.BindExpr> bindExprs = new ArrayList<PrintContext.BindExpr>();
        private boolean isCountQuery = false;
        private FieldIdentifier entity = null;
        private boolean isAggregate = false;
        private boolean forUpdate = false;
        private int queryDepth = 0;

        private Standard() {
        }

        @Override
        public FieldIdentifier getEntity() {
            return this.entity;
        }

        @Override
        public void setEntity(FieldIdentifier entity) {
            this.entity = entity;
        }

        @Override
        public boolean isCountQuery() {
            return this.isCountQuery;
        }

        @Override
        public void setIsCountQuery(boolean isCountQuery) {
            this.isCountQuery = isCountQuery;
        }

        @Override
        public String addBindExpr(Expr expr) {
            String name = "tmpVar" + (this.bindExprs.size() + 1);
            this.bindExprs.add(new PrintContext.BindExpr(name, expr));
            return name;
        }

        @Override
        public List<PrintContext.BindExpr> getBindExprs() {
            return this.bindExprs;
        }

        @Override
        public void checkAggregate(boolean isAggregate) {
            this.isAggregate |= isAggregate;
        }

        @Override
        public boolean isAggregate() {
            return this.isAggregate;
        }

        @Override
        public void pushQueryDepth() {
            ++this.queryDepth;
        }

        @Override
        public int getQueryDepth() {
            return this.queryDepth;
        }

        @Override
        public void popQueryDepth() {
            --this.queryDepth;
        }

        @Override
        public boolean isForUpdate() {
            return this.forUpdate;
        }

        @Override
        public void setForUpdate(boolean forUpdate) {
            this.forUpdate = forUpdate;
        }
    }

    private static final class Empty
    implements PrintContext {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        public FieldIdentifier getEntity() {
            return null;
        }

        @Override
        public void setEntity(FieldIdentifier entity) {
        }

        @Override
        public boolean isCountQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIsCountQuery(boolean isCountQuery) {
        }

        @Override
        public String addBindExpr(Expr expr) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PrintContext.BindExpr> getBindExprs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkAggregate(boolean isAggregate) {
        }

        @Override
        public boolean isAggregate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pushQueryDepth() {
        }

        @Override
        public int getQueryDepth() {
            return 0;
        }

        @Override
        public void popQueryDepth() {
        }

        @Override
        public boolean isForUpdate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setForUpdate(boolean forUpdate) {
        }
    }
}

