/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.addons;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class OSXStartupAddon {
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;

    @PostConstruct
    public void setupOSXApplicationMenu() {
        Menu systemMenu;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (systemMenu = Display.getDefault().getSystemMenu()) != null) {
            int prefsIndex = systemMenu.indexOf(this.getItem(systemMenu, -2));
            MenuItem updatesMenuItem = new MenuItem(systemMenu, 64, prefsIndex + 1);
            updatesMenuItem.setText(Messages.SystemMenuCheckForUpdates);
            updatesMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OSXStartupAddon.this.executeCommand("name.abuchen.portfolio.ui.command.updateproduct", new String[0]);
                }
            });
            MenuItem noteworthyMenuItem = new MenuItem(systemMenu, 64, prefsIndex + 2);
            noteworthyMenuItem.setText(Messages.SystemMenuNewAndNoteworthy);
            noteworthyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OSXStartupAddon.this.executeCommand("name.abuchen.portfolio.ui.command.openBrowser", "name.abuchen.portfolio.ui.param.url", "https://forum.portfolio-performance.info/t/sunny-neues-nennenswertes/23/last");
                }
            });
            MenuItem changelogMenuItem = new MenuItem(systemMenu, 64, prefsIndex + 3);
            changelogMenuItem.setText(Messages.SystemMenuChangelog);
            changelogMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OSXStartupAddon.this.executeCommand("name.abuchen.portfolio.ui.command.openBrowser", "name.abuchen.portfolio.ui.param.url", "https://www.portfolio-performance.info/portfolio/versions.html");
                }
            });
        }
    }

    private MenuItem getItem(Menu menu, int id) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getID() == id) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    private void executeCommand(String command, String ... parameters) {
        try {
            ParameterizedCommand pCmd;
            Command cmd = this.commandService.getCommand(command);
            ArrayList<Parameterization> parameterizations = new ArrayList<Parameterization>();
            if (parameters != null) {
                int ii = 0;
                while (ii < parameters.length) {
                    IParameter p = cmd.getParameter(parameters[ii]);
                    parameterizations.add(new Parameterization(p, parameters[ii + 1]));
                    ii += 2;
                }
            }
            if (this.handlerService.canExecute(pCmd = new ParameterizedCommand(cmd, parameterizations.toArray(new Parameterization[0])))) {
                this.handlerService.executeHandler(pCmd);
            }
        }
        catch (NotDefinedException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
        }
    }
}

