/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.addons;

import javax.inject.Inject;
import name.abuchen.portfolio.online.Factory;
import name.abuchen.portfolio.online.impl.AlphavantageQuoteFeed;
import name.abuchen.portfolio.online.impl.DivvyDiaryDividendFeed;
import name.abuchen.portfolio.online.impl.FinnhubQuoteFeed;
import name.abuchen.portfolio.online.impl.QuandlQuoteFeed;
import name.abuchen.portfolio.util.FormatHelper;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;

public class Preference2EnvAddon {
    @Inject
    @Optional
    public void setAlphavantageApiKey(@Preference(value="ALPHAVANTAGE_API_KEY") String alphavantageApiKey, @Preference(value="ALPHAVANTAGE_CALL_FREQUENCY_LIMIT") int callFrequencyLimit) {
        AlphavantageQuoteFeed quoteFeed = (AlphavantageQuoteFeed)Factory.getQuoteFeedProvider((String)"ALPHAVANTAGE");
        quoteFeed.setApiKey(alphavantageApiKey);
        quoteFeed.setCallFrequencyLimit(callFrequencyLimit);
    }

    @Inject
    @Optional
    public void setQuandlApiKey(@Preference(value="QUANDL_API_KEY") String quandlApiKey) {
        ((QuandlQuoteFeed)Factory.getQuoteFeedProvider((String)"QUANDL-DATASETS")).setApiKey(quandlApiKey);
    }

    @Inject
    @Optional
    public void setFinnhubApiKey(@Preference(value="FINNHUB_API_KEY") String finnhubApiKey) {
        ((FinnhubQuoteFeed)Factory.getQuoteFeedProvider((String)"FINNHUB-CANDLE")).setApiKey(finnhubApiKey);
    }

    @Inject
    @Optional
    public void setDivvyDiaryApiKey(@Preference(value="DIVVYDIARY_API_KEY") String divvyDiaryApiKey) {
        ((DivvyDiaryDividendFeed)Factory.getDividendFeed(DivvyDiaryDividendFeed.class)).setApiKey(divvyDiaryApiKey);
    }

    @Inject
    @Optional
    public void setDefaultCalendar(@Preference(value="CALENDAR") String defaultCalendarCode) {
        TradeCalendarManager.setDefaultCalendarCode((String)defaultCalendarCode);
    }

    @Inject
    public void setSharesPrecision(@Preference(value="FORMAT_SHARES_DIGITS") int sharesPrecision) {
        FormatHelper.setSharesDisplayPrecision((int)sharesPrecision);
    }

    @Inject
    public void setQuotePrecision(@Preference(value="FORMAT_CALCULATED_QUOTE_DIGITS") int quotePrecision) {
        FormatHelper.setCalculatedQuoteDisplayPrecision((int)quotePrecision);
    }
}

