/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import name.abuchen.portfolio.util.BuildInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class AboutDialog
extends Dialog {
    private static final int DETAILS_BTN_ID = 4711;
    private Composite container;
    private StackLayout layout;
    private Text infoTextBox;

    @Inject
    public AboutDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.container = new Composite(parent, 0);
        this.layout = new StackLayout();
        this.container.setLayout((Layout)this.layout);
        this.layout.topControl = this.createAboutText(this.container);
        this.createInfoArea(this.container);
        return this.container;
    }

    private Control createAboutText(Composite parent) {
        String aboutText = MessageFormat.format(Messages.AboutText, PortfolioPlugin.getDefault().getBundle().getVersion().toString(), DateTimeFormatter.ofPattern("MMM YYYY").format(BuildInfo.INSTANCE.getBuildTime()), System.getProperty("osgi.os"), System.getProperty("osgi.arch"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor"));
        Composite area = new Composite(parent, 0);
        area.setBackground(Display.getDefault().getSystemColor(1));
        this.getShell().setText(Messages.LabelAbout);
        Label imageLabel = new Label(area, 0);
        imageLabel.setBackground(area.getBackground());
        imageLabel.setImage(Images.LOGO_128.image());
        ArrayList<Object> styles = new ArrayList<StyleRange>();
        aboutText = this.addMarkdownLikeHyperlinks(aboutText, styles);
        this.addBoldFirstLine(aboutText, styles);
        Collections.sort(styles, (o1, o2) -> Integer.compare(o1.start, o2.start));
        StyledText aboutTextBox = new StyledText(area, 74);
        aboutTextBox.setText(aboutText);
        aboutTextBox.setStyleRanges(styles.toArray(new StyleRange[0]));
        aboutTextBox.addListener(3, e -> this.openBrowser(e, aboutTextBox));
        String contributionsText = Messages.AboutTextContributions;
        styles = new ArrayList();
        contributionsText = this.addMarkdownLikeHyperlinks(contributionsText, styles);
        StyledText contributionsBox = new StyledText(area, 74);
        contributionsBox.setText(contributionsText);
        contributionsBox.setStyleRanges(styles.toArray(new StyleRange[0]));
        contributionsBox.addListener(3, e -> this.openBrowser(e, contributionsBox));
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).spacing(10, 10).applyTo(area);
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 128).applyTo((Control)imageLabel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)aboutTextBox);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)contributionsBox);
        return area;
    }

    private void createInfoArea(Composite container) {
        Composite area = new Composite(container, 0);
        area.setLayout((Layout)new FillLayout());
        this.infoTextBox = new Text(area, 776);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
        this.createButton(parent, 4711, Messages.LabelInstallationDetails, false);
    }

    protected void buttonPressed(int buttonId) {
        boolean showsAbout;
        if (buttonId != 4711) {
            super.buttonPressed(buttonId);
            return;
        }
        boolean bl = showsAbout = this.layout.topControl == this.container.getChildren()[0];
        if (showsAbout) {
            this.infoTextBox.setText(this.buildInfoText());
            this.layout.topControl = this.container.getChildren()[1];
            this.container.layout();
            this.getButton(4711).setText(Messages.LabelInfo);
        } else {
            this.layout.topControl = this.container.getChildren()[0];
            this.container.layout();
            this.getButton(4711).setText(Messages.LabelInstallationDetails);
        }
    }

    private String addMarkdownLikeHyperlinks(String aboutText, List<StyleRange> styles) {
        Pattern pattern = Pattern.compile("\\[(?<text>[^\\]]*)\\]\\((?<link>[^\\)]*)\\)");
        Matcher matcher = pattern.matcher(aboutText);
        StringBuilder answer = new StringBuilder(aboutText.length());
        int pointer = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            answer.append(aboutText.substring(pointer, start));
            String text = matcher.group("text");
            String link = matcher.group("link");
            StyleRange styleRange = new StyleRange();
            styleRange.underline = true;
            styleRange.underlineStyle = 4;
            styleRange.underlineColor = Colors.theme().hyperlink();
            styleRange.foreground = Colors.theme().hyperlink();
            styleRange.data = link;
            styleRange.start = answer.length();
            styleRange.length = text.length();
            styles.add(styleRange);
            answer.append(text);
            pointer = end;
        }
        if (pointer < aboutText.length()) {
            answer.append(aboutText.substring(pointer));
        }
        return answer.toString();
    }

    private void addBoldFirstLine(String aboutText, List<StyleRange> ranges) {
        StyleRange styleRange = new StyleRange();
        styleRange.fontStyle = 1;
        styleRange.start = 0;
        styleRange.length = aboutText.indexOf(10);
        ranges.add(styleRange);
    }

    private void openBrowser(Event event, StyledText textBox) {
        int offset = textBox.getOffsetAtPoint(new Point(event.x, event.y));
        if (offset == -1) {
            return;
        }
        StyleRange style = textBox.getStyleRangeAtOffset(offset);
        if (style != null && style.data != null) {
            DesktopAPI.browse(String.valueOf(style.data));
        }
    }

    private String buildInfoText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Generated at " + LocalDateTime.now());
        builder.append("\n\nSystem Properties:\n\n");
        System.getProperties().entrySet().stream().sorted((r, l) -> r.getKey().toString().compareTo(l.getKey().toString())).forEach(e -> {
            StringBuilder stringBuilder2 = builder.append(e.getKey() + ": " + e.getValue() + "\n");
        });
        builder.append("\n\nOSGi Bundles:\n\n");
        Bundle[] bundles = PortfolioPlugin.getDefault().getBundle().getBundleContext().getBundles();
        Arrays.sort(bundles, (r, l) -> r.getSymbolicName().compareTo(l.getSymbolicName()));
        int ii = 0;
        while (ii < bundles.length) {
            Bundle b = bundles[ii];
            builder.append(String.valueOf(b.getSymbolicName()) + " (" + b.getVersion().toString() + ")");
            this.addSignerInfo(builder, b);
            if (!b.getSignerCertificates(2).isEmpty()) {
                builder.append(" [trusted]");
            }
            builder.append("\n");
            ++ii;
        }
        return builder.toString();
    }

    private void addSignerInfo(StringBuilder builder, Bundle b) {
        Map certificates = b.getSignerCertificates(1);
        if (certificates.isEmpty()) {
            return;
        }
        builder.append(" [signed by ");
        boolean isFirstCertificate = true;
        for (X509Certificate cert : certificates.keySet()) {
            try {
                LdapName ldapDN = new LdapName(cert.getSubjectDN().getName());
                for (Rdn rdn : ldapDN.getRdns()) {
                    if (!"CN".equals(rdn.getType())) continue;
                    if (!isFirstCertificate) {
                        builder.append(", ");
                    }
                    builder.append(rdn.getValue());
                    isFirstCertificate = false;
                }
            }
            catch (InvalidNameException invalidNameException) {
                // empty catch block
            }
        }
        builder.append("]");
    }
}

