/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DisplayTextDialog
extends Dialog {
    private File source;
    private String text;
    private Text widget;

    public DisplayTextDialog(Shell parentShell, String text) {
        this(parentShell, null, text);
    }

    public DisplayTextDialog(Shell parentShell, File source, String text) {
        super(parentShell);
        this.source = source;
        this.text = text;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        Button button = this.createButton(parent, 9999, Messages.LabelCopyToClipboard, false);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.widget.isDisposed()) {
                return;
            }
            Clipboard cb = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            cb.setContents(new Object[]{this.widget.getText()}, new Transfer[]{textTransfer});
        }));
        button = this.createButton(parent, 9998, Messages.LabelSaveInFile, false);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.widget.isDisposed()) {
                return;
            }
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            if (this.source != null) {
                dialog.setFilterPath(this.source.getAbsolutePath());
                dialog.setFileName(String.valueOf(this.source.getName()) + ".txt");
            } else {
                dialog.setFileName(String.valueOf(Messages.LabelUnnamedFile) + ".txt");
            }
            dialog.setOverwrite(true);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(path, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                    writer.write(this.widget.getText());
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x);
            }
        }));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 200).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        this.widget = new Text(container, 2634);
        this.widget.setText(this.text);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.widget);
        return container;
    }
}

