/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ContextMenu;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class EditReportingPeriodsDialog
extends Dialog {
    private TableViewer tableViewer;
    private List<ReportingPeriod> periods;

    public EditReportingPeriodsDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setReportingPeriods(List<ReportingPeriod> periods) {
        this.periods = new ArrayList<ReportingPeriod>(periods);
    }

    public List<ReportingPeriod> getReportingPeriods() {
        return this.periods;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LabelReportInterval);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite tableArea = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 300).applyTo((Control)tableArea);
        TableColumnLayout layout = new TableColumnLayout();
        tableArea.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(tableArea, 2050);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return Images.TEXT.image();
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.periods);
        this.tableViewer.getTable().addKeyListener(KeyListener.keyReleasedAdapter(e -> {
            if (e.character == '\b' || e.character == '\u007f') {
                this.deleteSelectedItems();
            }
        }));
        this.setupDnD();
        new ContextMenu((Control)this.tableViewer.getTable(), this::fillContextMenu).hook();
        Label info = new Label(container, 0);
        info.setText(TextUtil.tooltip((String)Messages.LabelReportingPeriodEditTooltip));
        return container;
    }

    private void setupDnD() {
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.tableViewer.addDragSupport(2, types, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EditReportingPeriodsDialog.this.tableViewer.getSelection();
                boolean bl = event.doit = selection.size() < EditReportingPeriodsDialog.this.tableViewer.getTable().getItemCount();
                if (event.doit) {
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                    LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                }
            }
        });
        this.tableViewer.addDropSupport(2, types, (DropTargetListener)new ViewerDropAdapter((Viewer)this.tableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)data;
                ArrayList<ReportingPeriod> movedItems = new ArrayList<ReportingPeriod>();
                for (Object o : selection.toList()) {
                    movedItems.add((ReportingPeriod)o);
                }
                EditReportingPeriodsDialog.this.periods.removeAll(movedItems);
                Object destination = this.getCurrentTarget();
                int index = EditReportingPeriodsDialog.this.periods.indexOf(destination);
                if (index >= 0) {
                    int location = this.getCurrentLocation();
                    if (location == 3 || location == 2) {
                        ++index;
                    }
                    EditReportingPeriodsDialog.this.periods.addAll(index, movedItems);
                }
                EditReportingPeriodsDialog.this.tableViewer.refresh();
                return true;
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new SimpleAction(Messages.MenuReportingPeriodDelete, a -> this.deleteSelectedItems()));
    }

    private void deleteSelectedItems() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.periods.remove(o);
            ++n2;
        }
        this.tableViewer.refresh();
    }
}

