/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.palette;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.palette.CommandPalettePopup;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;

class TransactionElements
implements CommandPalettePopup.ElementProvider {
    @Inject
    private PortfolioPart part;
    @Inject
    private SelectionService selectionService;

    TransactionElements() {
    }

    @Override
    public List<CommandPalettePopup.Element> getElements() {
        Optional<SecuritySelection> selection = this.selectionService.getSelection(this.part.getClient());
        ArrayList<CommandPalettePopup.Element> elements = new ArrayList<CommandPalettePopup.Element>();
        for (AccountTransaction.Type type : EnumSet.of(AccountTransaction.Type.DEPOSIT, new AccountTransaction.Type[]{AccountTransaction.Type.REMOVAL, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE, AccountTransaction.Type.DIVIDENDS})) {
            elements.add(new AccountTransactionElement(AccountTransactionDialog.class, type, selection));
        }
        for (PortfolioTransaction.Type type : EnumSet.of(PortfolioTransaction.Type.BUY, PortfolioTransaction.Type.SELL, PortfolioTransaction.Type.DELIVERY_INBOUND, PortfolioTransaction.Type.DELIVERY_OUTBOUND)) {
            elements.add(new AccountTransactionElement(SecurityTransactionDialog.class, type, selection));
        }
        if (this.part.getClient().getActivePortfolios().size() > 1) {
            elements.add(new AccountTransactionElement(SecurityTransferDialog.class, Messages.LabelSecurityTransfer, selection));
        }
        if (this.part.getClient().getActiveAccounts().size() > 1) {
            elements.add(new AccountTransactionElement(AccountTransferDialog.class, Messages.LabelAccountTransfer, selection));
        }
        return elements;
    }

    private class AccountTransactionElement
    implements CommandPalettePopup.Element {
        private final Class<? extends AbstractTransactionDialog> dialog;
        private final Object transaction;
        private final Optional<SecuritySelection> selection;

        public AccountTransactionElement(Class<? extends AbstractTransactionDialog> dialog, Object transaction, Optional<SecuritySelection> selection) {
            this.dialog = dialog;
            this.transaction = transaction;
            this.selection = selection;
        }

        @Override
        public String getTitel() {
            return this.transaction.toString();
        }

        @Override
        public String getSubtitle() {
            return this.selection.isPresent() && this.hasSecurity() ? MessageFormat.format((String)Messages.LabelNewTransactionForSecurity, (Object[])new Object[]{this.selection.get().getSecurity().getName()}) : Messages.LabelNewTransaction;
        }

        private boolean hasSecurity() {
            if (this.transaction instanceof PortfolioTransaction.Type) {
                return true;
            }
            return EnumSet.of(AccountTransaction.Type.DIVIDENDS, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND).contains(this.transaction);
        }

        @Override
        public Images getImage() {
            return Images.NEW_TRANSACTION;
        }

        @Override
        public void execute() {
            TransactionElements.this.part.getCurrentView().ifPresent(view -> {
                OpenDialogAction action = new OpenDialogAction((AbstractFinanceView)view, String.valueOf(this.transaction.toString()) + "...");
                action.type(this.dialog);
                if (Enum.class.isAssignableFrom(this.transaction.getClass())) {
                    action.parameters(this.transaction);
                }
                if (this.selection.isPresent()) {
                    action.with(this.selection.get().getSecurity());
                }
                action.run();
            });
        }
    }
}

