/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import com.ibm.icu.text.MessageFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRate;
import name.abuchen.portfolio.money.ExchangeRateTimeSeries;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class AccountTransactionModel
extends AbstractModel {
    public static final Security EMPTY_SECURITY = new Security("-----", "");
    private final Client client;
    private AccountTransaction.Type type;
    private Account sourceAccount;
    private AccountTransaction sourceTransaction;
    private Security security;
    private Account account;
    private LocalDate date = LocalDate.now();
    private LocalTime time = LocalTime.MIDNIGHT;
    private long shares;
    private long fxGrossAmount;
    private BigDecimal dividendAmount = BigDecimal.ZERO;
    private BigDecimal exchangeRate = BigDecimal.ONE;
    private long grossAmount;
    private long fxTaxes;
    private long taxes;
    private long fxFees;
    private long fees;
    private long total;
    private String note;
    private IStatus calculationStatus = ValidationStatus.ok();

    public AccountTransactionModel(Client client, AccountTransaction.Type type) {
        this.client = client;
        this.type = type;
        this.checkType();
    }

    @Override
    public String getHeading() {
        return this.type.toString();
    }

    private void checkType() {
        switch (this.type) {
            case DEPOSIT: 
            case REMOVAL: 
            case INTEREST: 
            case INTEREST_CHARGE: 
            case DIVIDENDS: 
            case FEES: 
            case FEES_REFUND: 
            case TAXES: 
            case TAX_REFUND: {
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyChanges() {
        String fxCurrencyCode;
        AccountTransaction t;
        if (this.security == null && this.supportsSecurity() && !this.supportsOptionalSecurity()) {
            throw new UnsupportedOperationException(Messages.MsgMissingSecurity);
        }
        if (this.account == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingAccount);
        }
        if (this.sourceTransaction != null && this.sourceAccount.equals(this.account)) {
            t = this.sourceTransaction;
        } else {
            if (this.sourceTransaction != null) {
                this.sourceAccount.deleteTransaction((Transaction)this.sourceTransaction, this.client);
                this.sourceTransaction = null;
                this.sourceAccount = null;
            }
            t = new AccountTransaction();
            t.setCurrencyCode(this.getAccountCurrencyCode());
            this.account.addTransaction(t);
        }
        t.setDateTime(LocalDateTime.of(this.date, this.time));
        t.setSecurity(!EMPTY_SECURITY.equals(this.security) ? this.security : null);
        t.setShares(this.supportsShares() ? this.shares : 0L);
        t.setAmount(this.total);
        t.setType(this.type);
        t.setNote(this.note);
        t.clearUnits();
        if (this.fees != 0L) {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of((String)this.getAccountCurrencyCode(), (long)this.fees)));
        }
        if (this.taxes != 0L) {
            t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of((String)this.getAccountCurrencyCode(), (long)this.taxes)));
        }
        if (!(fxCurrencyCode = this.getFxCurrencyCode()).equals(this.account.getCurrencyCode())) {
            Transaction.Unit forex = new Transaction.Unit(Transaction.Unit.Type.GROSS_VALUE, Money.of((String)this.getAccountCurrencyCode(), (long)this.grossAmount), Money.of((String)this.getSecurityCurrencyCode(), (long)this.fxGrossAmount), this.getExchangeRate());
            t.addUnit(forex);
            if (this.fxFees != 0L) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.FEE, Money.of((String)this.getAccountCurrencyCode(), (long)Math.round((double)this.fxFees * this.exchangeRate.doubleValue())), Money.of((String)this.getSecurityCurrencyCode(), (long)this.fxFees), this.exchangeRate));
            }
            if (this.fxTaxes != 0L) {
                t.addUnit(new Transaction.Unit(Transaction.Unit.Type.TAX, Money.of((String)this.getAccountCurrencyCode(), (long)Math.round((double)this.fxTaxes * this.exchangeRate.doubleValue())), Money.of((String)this.getSecurityCurrencyCode(), (long)this.fxTaxes), this.exchangeRate));
            }
        }
    }

    @Override
    public void resetToNewTransaction() {
        this.sourceAccount = null;
        this.sourceTransaction = null;
        this.setFxGrossAmount(0L);
        this.setDividendAmount(BigDecimal.ZERO);
        this.setGrossAmount(0L);
        this.setFees(0L);
        this.setFxFees(0L);
        this.setTaxes(0L);
        this.setFxTaxes(0L);
        this.setNote(null);
    }

    public boolean supportsShares() {
        return this.type == AccountTransaction.Type.DIVIDENDS;
    }

    public boolean supportsSecurity() {
        switch (this.type) {
            case DIVIDENDS: 
            case FEES: 
            case FEES_REFUND: 
            case TAXES: 
            case TAX_REFUND: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsOptionalSecurity() {
        switch (this.type) {
            case FEES: 
            case FEES_REFUND: 
            case TAXES: 
            case TAX_REFUND: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsTaxUnits() {
        return this.type == AccountTransaction.Type.DIVIDENDS || this.type == AccountTransaction.Type.INTEREST;
    }

    public boolean supportsFees() {
        return this.type == AccountTransaction.Type.DIVIDENDS;
    }

    public void setSource(Account account, AccountTransaction transaction) {
        this.sourceAccount = account;
        this.sourceTransaction = transaction;
        this.security = transaction.getSecurity();
        if (this.security == null && this.supportsOptionalSecurity()) {
            this.security = EMPTY_SECURITY;
        }
        this.account = account;
        LocalDateTime transactionDate = transaction.getDateTime();
        this.date = transactionDate.toLocalDate();
        this.time = transactionDate.toLocalTime();
        this.shares = transaction.getShares();
        this.total = transaction.getAmount();
        this.exchangeRate = BigDecimal.ONE;
        this.taxes = 0L;
        this.fxTaxes = 0L;
        this.fees = 0L;
        this.fxFees = 0L;
        transaction.getUnits().forEach(unit -> {
            switch (unit.getType()) {
                case GROSS_VALUE: {
                    this.exchangeRate = unit.getExchangeRate();
                    this.grossAmount = unit.getAmount().getAmount();
                    this.fxGrossAmount = unit.getForex().getAmount();
                    break;
                }
                case TAX: {
                    if (unit.getForex() != null) {
                        this.fxTaxes += unit.getForex().getAmount();
                        break;
                    }
                    this.taxes += unit.getAmount().getAmount();
                    break;
                }
                case FEE: {
                    if (unit.getForex() != null) {
                        this.fxFees += unit.getForex().getAmount();
                        break;
                    }
                    this.fees += unit.getAmount().getAmount();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        });
        this.grossAmount = this.calculateGrossAmount4Total();
        if (this.exchangeRate.equals(BigDecimal.ONE)) {
            this.fxGrossAmount = this.grossAmount;
        }
        this.dividendAmount = this.calculateDividendAmount();
        this.note = transaction.getNote();
    }

    @Override
    public IStatus getCalculationStatus() {
        return this.calculationStatus;
    }

    private IStatus calculateStatus() {
        long upper = Math.round((double)this.fxGrossAmount * this.exchangeRate.add(BigDecimal.valueOf(1.0E-4)).doubleValue());
        long lower = Math.round((double)this.fxGrossAmount * this.exchangeRate.add(BigDecimal.valueOf(-1.0E-4)).doubleValue());
        if (this.grossAmount < lower || this.grossAmount > upper) {
            return ValidationStatus.error((String)Messages.MsgErrorConvertedAmount);
        }
        if (this.grossAmount == 0L) {
            return ValidationStatus.error((String)MessageFormat.format((String)Messages.MsgDialogInputRequired, (Object[])new Object[]{Messages.ColumnTotal}));
        }
        return ValidationStatus.ok();
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        String oldCurrencyCode = this.getAccountCurrencyCode();
        String oldFxCurrencyCode = this.getFxCurrencyCode();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.account = account;
        this.firePropertyChange(Properties.account.name(), this.account, this.account);
        this.firePropertyChange(Properties.accountCurrencyCode.name(), oldCurrencyCode, this.getAccountCurrencyCode());
        this.firePropertyChange(Properties.fxCurrencyCode.name(), oldFxCurrencyCode, this.getFxCurrencyCode());
        this.firePropertyChange(Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateExchangeRate();
    }

    public Security getSecurity() {
        return this.security;
    }

    public void setSecurity(Security security) {
        if (!this.supportsSecurity()) {
            return;
        }
        String oldCurrencyCode = this.getSecurityCurrencyCode();
        String oldFxCurrencyCode = this.getFxCurrencyCode();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.security = security;
        this.firePropertyChange(Properties.security.name(), this.security, this.security);
        this.firePropertyChange(Properties.securityCurrencyCode.name(), oldCurrencyCode, this.getSecurityCurrencyCode());
        this.firePropertyChange(Properties.fxCurrencyCode.name(), oldFxCurrencyCode, this.getFxCurrencyCode());
        this.firePropertyChange(Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateExchangeRate();
        this.updateShares();
    }

    private void updateExchangeRate() {
        if (this.getAccountCurrencyCode().equals(this.getSecurityCurrencyCode()) || this.getSecurityCurrencyCode().isEmpty()) {
            this.setExchangeRate(BigDecimal.ONE);
            return;
        }
        if (this.sourceTransaction != null) {
            return;
        }
        if (!this.getSecurityCurrencyCode().isEmpty()) {
            ExchangeRateTimeSeries series = this.getExchangeRateProviderFactory().getTimeSeries(this.getSecurityCurrencyCode(), this.getAccountCurrencyCode());
            if (series != null) {
                this.setExchangeRate(series.lookupRate(this.date).orElse(new ExchangeRate(this.date, BigDecimal.ONE)).getValue());
            } else {
                this.setExchangeRate(BigDecimal.ONE);
            }
        }
    }

    private void updateShares() {
        if (this.sourceTransaction != null) {
            return;
        }
        if (!this.supportsShares() || this.security == null) {
            return;
        }
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.getExchangeRateProviderFactory(), this.client.getBaseCurrency());
        ClientSnapshot snapshot = ClientSnapshot.create((Client)this.client, (CurrencyConverter)converter, (LocalDate)this.date);
        SecurityPosition p = (SecurityPosition)snapshot.getJointPortfolio().getPositionsBySecurity().get(this.security);
        this.setShares(p != null ? p.getShares() : 0L);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
        this.firePropertyChange(Properties.date.name(), this.date, this.date);
        this.updateShares();
        this.updateExchangeRate();
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setTime(LocalTime time) {
        this.time = time;
        this.firePropertyChange(Properties.time.name(), this.time, this.time);
    }

    public long getShares() {
        return this.shares;
    }

    public void setShares(long shares) {
        this.shares = shares;
        this.firePropertyChange(Properties.shares.name(), this.shares, this.shares);
        this.dividendAmount = this.calculateDividendAmount();
        this.firePropertyChange(Properties.dividendAmount.name(), this.dividendAmount, this.dividendAmount);
    }

    public long getFxGrossAmount() {
        return this.fxGrossAmount;
    }

    public void setFxGrossAmount(long foreignCurrencyAmount) {
        this.fxGrossAmount = foreignCurrencyAmount;
        this.firePropertyChange(Properties.fxGrossAmount.name(), this.fxGrossAmount, this.fxGrossAmount);
        this.triggerGrossAmount(Math.round(this.exchangeRate.doubleValue() * (double)foreignCurrencyAmount));
        this.dividendAmount = this.calculateDividendAmount();
        this.firePropertyChange(Properties.dividendAmount.name(), this.dividendAmount, this.dividendAmount);
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getDividendAmount() {
        return this.dividendAmount;
    }

    public void setDividendAmount(BigDecimal amount) {
        this.triggerDividendAmount(amount);
        long myGrossAmount = this.calculateGrossAmount4Dividend();
        this.setFxGrossAmount(myGrossAmount);
    }

    public void triggerDividendAmount(BigDecimal amount) {
        this.dividendAmount = amount;
        this.firePropertyChange(Properties.dividendAmount.name(), this.dividendAmount, this.dividendAmount);
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        BigDecimal newRate = exchangeRate == null ? BigDecimal.ZERO : exchangeRate;
        BigDecimal oldInverseRate = this.getInverseExchangeRate();
        this.exchangeRate = newRate;
        this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
        this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
        this.triggerGrossAmount(Math.round(newRate.doubleValue() * (double)this.fxGrossAmount));
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public BigDecimal getInverseExchangeRate() {
        return BigDecimal.ONE.divide(this.exchangeRate, 10, RoundingMode.HALF_DOWN);
    }

    public void setInverseExchangeRate(BigDecimal rate) {
        this.setExchangeRate(BigDecimal.ONE.divide(rate, 10, RoundingMode.HALF_DOWN));
    }

    public long getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(long amount) {
        this.triggerGrossAmount(amount);
        if (this.fxGrossAmount != 0L) {
            BigDecimal newExchangeRate = BigDecimal.valueOf(amount).divide(BigDecimal.valueOf(this.fxGrossAmount), 10, RoundingMode.HALF_UP);
            BigDecimal oldInverseRate = this.getInverseExchangeRate();
            this.exchangeRate = newExchangeRate;
            this.firePropertyChange(Properties.exchangeRate.name(), this.exchangeRate, this.exchangeRate);
            this.firePropertyChange(Properties.inverseExchangeRate.name(), oldInverseRate, this.getInverseExchangeRate());
        }
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerGrossAmount(long amount) {
        this.grossAmount = amount;
        this.firePropertyChange(Properties.grossAmount.name(), this.grossAmount, this.grossAmount);
        this.triggerTotal(this.calculateTotal());
    }

    public long getFxTaxes() {
        return this.fxTaxes;
    }

    public long getFxFees() {
        return this.fxFees;
    }

    public void setFxTaxes(long fxTaxes) {
        this.fxTaxes = fxTaxes;
        this.firePropertyChange(Properties.fxTaxes.name(), this.fxTaxes, this.fxTaxes);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void setFxFees(long fxFees) {
        this.fxFees = fxFees;
        this.firePropertyChange(Properties.fxFees.name(), this.fxFees, this.fxFees);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getTaxes() {
        return this.taxes;
    }

    public long getFees() {
        return this.fees;
    }

    public void setTaxes(long taxes) {
        this.taxes = taxes;
        this.firePropertyChange(Properties.taxes.name(), this.taxes, this.taxes);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void setFees(long fees) {
        this.fees = fees;
        this.firePropertyChange(Properties.fees.name(), this.fees, this.fees);
        this.triggerTotal(this.calculateTotal());
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.triggerTotal(total);
        this.grossAmount = this.calculateGrossAmount4Total();
        this.firePropertyChange(Properties.grossAmount.name(), this.grossAmount, this.grossAmount);
        this.fxGrossAmount = Math.round((double)this.grossAmount / this.exchangeRate.doubleValue());
        this.firePropertyChange(Properties.fxGrossAmount.name(), this.fxGrossAmount, this.fxGrossAmount);
        this.dividendAmount = this.calculateDividendAmount();
        this.firePropertyChange(Properties.dividendAmount.name(), this.dividendAmount, this.dividendAmount);
        this.calculationStatus = this.calculateStatus();
        this.firePropertyChange(Properties.calculationStatus.name(), this.calculationStatus, this.calculationStatus);
    }

    public void triggerTotal(long total) {
        this.total = total;
        this.firePropertyChange(Properties.total.name(), this.total, this.total);
    }

    protected BigDecimal calculateDividendAmount() {
        if (this.shares > 0L) {
            return BigDecimal.valueOf((double)(this.fxGrossAmount * (long)Values.Share.factor()) / (double)this.shares / Values.Amount.divider());
        }
        return BigDecimal.ZERO;
    }

    protected long calculateGrossAmount4Total() {
        long totalFees = this.fees + Math.round(this.exchangeRate.doubleValue() * (double)this.fxFees);
        long totalTaxes = this.taxes + Math.round(this.exchangeRate.doubleValue() * (double)this.fxTaxes);
        return this.total + totalFees + totalTaxes;
    }

    protected long calculateGrossAmount4Dividend() {
        return Math.round((double)this.shares * this.dividendAmount.doubleValue() * (double)Values.Amount.factor() / (double)Values.Share.factor());
    }

    private long calculateTotal() {
        long totalFees = this.fees + Math.round(this.exchangeRate.doubleValue() * (double)this.fxFees);
        long totalTaxes = this.taxes + Math.round(this.exchangeRate.doubleValue() * (double)this.fxTaxes);
        return Math.max(0L, this.grossAmount - totalTaxes - totalFees);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.firePropertyChange(Properties.note.name(), this.note, this.note);
    }

    public String getAccountCurrencyCode() {
        return this.account != null ? this.account.getCurrencyCode() : "";
    }

    public String getSecurityCurrencyCode() {
        return this.security != null ? this.security.getCurrencyCode() : "";
    }

    public String getFxCurrencyCode() {
        return this.security != null && !this.security.getCurrencyCode().isEmpty() ? this.security.getCurrencyCode() : this.getAccountCurrencyCode();
    }

    public String getExchangeRateCurrencies() {
        return String.format("%s/%s", this.getSecurityCurrencyCode(), this.getAccountCurrencyCode());
    }

    public String getInverseExchangeRateCurrencies() {
        return String.format("%s/%s", this.getAccountCurrencyCode(), this.getSecurityCurrencyCode());
    }

    public AccountTransaction.Type getType() {
        return this.type;
    }

    public static enum Properties {
        security,
        account,
        date,
        time,
        shares,
        fxGrossAmount,
        dividendAmount,
        exchangeRate,
        inverseExchangeRate,
        grossAmount,
        fxTaxes,
        taxes,
        fxFees,
        fees,
        total,
        note,
        exchangeRateCurrencies,
        inverseExchangeRateCurrencies,
        accountCurrencyCode,
        securityCurrencyCode,
        fxCurrencyCode,
        calculationStatus;

    }
}

