/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.time.LocalDateTime;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractSecurityTransactionModel;

public class SecurityDeliveryModel
extends AbstractSecurityTransactionModel {
    private TransactionPair<PortfolioTransaction> source;
    private CurrencyUnit transactionCurrency;

    public SecurityDeliveryModel(Client client, PortfolioTransaction.Type type) {
        super(client, type);
        if (!this.accepts(type)) {
            throw new IllegalArgumentException();
        }
        this.transactionCurrency = CurrencyUnit.getInstance((String)client.getBaseCurrency());
    }

    @Override
    public boolean accepts(PortfolioTransaction.Type type) {
        return type == PortfolioTransaction.Type.DELIVERY_INBOUND || type == PortfolioTransaction.Type.DELIVERY_OUTBOUND;
    }

    @Override
    public void setSource(Object transaction) {
        this.source = (TransactionPair)transaction;
        this.type = ((PortfolioTransaction)this.source.getTransaction()).getType();
        this.portfolio = (Portfolio)this.source.getOwner();
        this.transactionCurrency = CurrencyUnit.getInstance((String)((PortfolioTransaction)this.source.getTransaction()).getCurrencyCode());
        this.fillFromTransaction((PortfolioTransaction)this.source.getTransaction());
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    @Override
    public void applyChanges() {
        TransactionPair entry;
        if (this.security == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingSecurity);
        }
        if (this.portfolio.getReferenceAccount() == null) {
            throw new UnsupportedOperationException(Messages.MsgMissingReferenceAccount);
        }
        if (this.source != null && this.source.getOwner().equals(this.portfolio)) {
            entry = this.source;
        } else {
            if (this.source != null) {
                this.source.getOwner().deleteTransaction((Transaction)((PortfolioTransaction)this.source.getTransaction()), this.client);
                this.source = null;
            }
            entry = new TransactionPair((TransactionOwner)this.portfolio, (Transaction)new PortfolioTransaction());
            this.portfolio.addTransaction((PortfolioTransaction)entry.getTransaction());
        }
        PortfolioTransaction transaction = (PortfolioTransaction)entry.getTransaction();
        transaction.setDateTime(LocalDateTime.of(this.date, this.time));
        transaction.setCurrencyCode(this.getTransactionCurrencyCode());
        transaction.setSecurity(this.security);
        transaction.setShares(this.shares);
        transaction.setAmount(this.total);
        transaction.setType(this.type);
        transaction.setNote(this.note);
        this.writeToTransaction(transaction);
    }

    @Override
    public void resetToNewTransaction() {
        this.source = null;
        super.resetToNewTransaction();
    }

    @Override
    public String getTransactionCurrencyCode() {
        return this.transactionCurrency.getCurrencyCode();
    }

    @Override
    public void setPortfolio(Portfolio portfolio) {
        this.setTransactionCurrency(CurrencyUnit.getInstance((String)portfolio.getReferenceAccount().getCurrencyCode()));
        super.setPortfolio(portfolio);
    }

    public CurrencyUnit getTransactionCurrency() {
        return this.transactionCurrency;
    }

    public void setTransactionCurrency(CurrencyUnit currency) {
        String oldCurrencyCode = this.getTransactionCurrencyCode();
        String oldExchangeRateCurrencies = this.getExchangeRateCurrencies();
        String oldInverseExchangeRateCurrencies = this.getInverseExchangeRateCurrencies();
        this.transactionCurrency = currency;
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.transactionCurrency.name(), this.transactionCurrency, this.transactionCurrency);
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name(), oldCurrencyCode, this.getTransactionCurrencyCode());
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.exchangeRateCurrencies.name(), oldExchangeRateCurrencies, this.getExchangeRateCurrencies());
        this.firePropertyChange(AbstractSecurityTransactionModel.Properties.inverseExchangeRateCurrencies.name(), oldInverseExchangeRateCurrencies, this.getInverseExchangeRateCurrencies());
        this.updateExchangeRate();
    }
}

