/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dialogs.transactions;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import name.abuchen.portfolio.model.BuySellEntry;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyUnit;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractModel;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractSecurityTransactionModel;
import name.abuchen.portfolio.ui.dialogs.transactions.AbstractTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.BuySellModel;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityDeliveryModel;
import name.abuchen.portfolio.ui.dialogs.transactions.StockSplitWarning;
import name.abuchen.portfolio.ui.dialogs.transactions.WarningMessages;
import name.abuchen.portfolio.ui.util.FormDataFactory;
import name.abuchen.portfolio.ui.util.SWTHelper;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SecurityTransactionDialog
extends AbstractTransactionDialog {
    @Inject
    private Client client;
    @Preference(value="USE_INDIRECT_QUOTATION")
    @Inject
    private boolean useIndirectQuotation = false;

    @Inject
    public SecurityTransactionDialog(@Named(value="activeShell") Shell parentShell) {
        super(parentShell);
    }

    @PostConstruct
    private void createModel(ExchangeRateProviderFactory factory, PortfolioTransaction.Type type) {
        List activeSecurities;
        boolean isBuySell = type == PortfolioTransaction.Type.BUY || type == PortfolioTransaction.Type.SELL;
        AbstractSecurityTransactionModel model = isBuySell ? new BuySellModel(this.client, type) : new SecurityDeliveryModel(this.client, type);
        model.setExchangeRateProviderFactory(factory);
        this.setModel(model);
        List activePortfolios = this.client.getActivePortfolios();
        if (activePortfolios.size() == 1) {
            model.setPortfolio((Portfolio)activePortfolios.get(0));
        }
        if (!(activeSecurities = this.client.getActiveSecurities()).isEmpty()) {
            model.setSecurity((Security)activeSecurities.get(0));
        }
    }

    private AbstractSecurityTransactionModel model() {
        return (AbstractSecurityTransactionModel)this.model;
    }

    @Override
    protected void createFormElements(Composite editArea) {
        AbstractTransactionDialog.ComboInput securities = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnSecurity);
        securities.value.setInput(this.including(this.client.getActiveSecurities(), this.model().getSecurity()));
        securities.bindValue(AbstractSecurityTransactionModel.Properties.security.name(), Messages.MsgMissingSecurity);
        securities.bindCurrency(AbstractSecurityTransactionModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.ComboInput portfolio = new AbstractTransactionDialog.ComboInput(this, editArea, Messages.ColumnPortfolio);
        portfolio.value.setInput(this.including(this.client.getActivePortfolios(), this.model().getPortfolio()));
        portfolio.bindValue(AbstractSecurityTransactionModel.Properties.portfolio.name(), Messages.MsgMissingPortfolio);
        AbstractTransactionDialog.ComboInput comboInput = new AbstractTransactionDialog.ComboInput(this, editArea, null);
        if (this.model() instanceof BuySellModel) {
            comboInput.value.setInput(this.including(this.client.getActiveAccounts(), ((BuySellModel)this.model()).getAccount()));
            comboInput.bindValue(AbstractSecurityTransactionModel.Properties.account.name(), Messages.MsgMissingAccount);
        } else {
            List availableCurrencies = CurrencyUnit.getAvailableCurrencyUnits();
            Collections.sort(availableCurrencies);
            comboInput.value.setInput((Object)availableCurrencies);
            comboInput.bindValue(AbstractSecurityTransactionModel.Properties.transactionCurrency.name(), Messages.MsgMissingAccount);
        }
        AbstractTransactionDialog.DateTimeInput dateTime = new AbstractTransactionDialog.DateTimeInput(this, editArea, Messages.ColumnDate);
        dateTime.bindDate(AbstractSecurityTransactionModel.Properties.date.name());
        dateTime.bindTime(AbstractSecurityTransactionModel.Properties.time.name());
        dateTime.bindButton(() -> this.model().getTime(), time -> this.model().setTime((LocalTime)time));
        AbstractTransactionDialog.Input shares = new AbstractTransactionDialog.Input(this, editArea, Messages.ColumnShares);
        shares.bindValue(AbstractSecurityTransactionModel.Properties.shares.name(), Messages.ColumnShares, Values.Share, true);
        AbstractTransactionDialog.Input quote = new AbstractTransactionDialog.Input(this, editArea, "x " + Messages.ColumnQuote);
        quote.bindBigDecimal(AbstractSecurityTransactionModel.Properties.quote.name(), Values.Quote.pattern());
        quote.bindCurrency(AbstractSecurityTransactionModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.Input grossValue = new AbstractTransactionDialog.Input(this, editArea, "=");
        grossValue.bindValue(AbstractSecurityTransactionModel.Properties.grossValue.name(), Messages.ColumnSubTotal, Values.Amount, true);
        grossValue.bindCurrency(AbstractSecurityTransactionModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.ExchangeRateInput exchangeRate = new AbstractTransactionDialog.ExchangeRateInput(this, editArea, this.useIndirectQuotation ? "/ " : "x ");
        exchangeRate.bindBigDecimal(this.useIndirectQuotation ? AbstractSecurityTransactionModel.Properties.inverseExchangeRate.name() : AbstractSecurityTransactionModel.Properties.exchangeRate.name(), Values.ExchangeRate.pattern());
        exchangeRate.bindCurrency(this.useIndirectQuotation ? AbstractSecurityTransactionModel.Properties.inverseExchangeRateCurrencies.name() : AbstractSecurityTransactionModel.Properties.exchangeRateCurrencies.name());
        exchangeRate.bindInvertAction(() -> this.model().setExchangeRate(BigDecimal.ONE.divide(this.model().getExchangeRate(), 10, RoundingMode.HALF_DOWN)));
        this.model().addPropertyChangeListener(AbstractSecurityTransactionModel.Properties.exchangeRate.name(), e -> exchangeRateInput.value.setToolTipText(AbstractModel.createCurrencyToolTip(this.model().getExchangeRate(), this.model().getTransactionCurrencyCode(), this.model().getSecurityCurrencyCode())));
        AbstractTransactionDialog.Input convertedGrossValue = new AbstractTransactionDialog.Input(this, editArea, "=");
        convertedGrossValue.bindValue(AbstractSecurityTransactionModel.Properties.convertedGrossValue.name(), Messages.ColumnSubTotal, Values.Amount, true);
        convertedGrossValue.bindCurrency(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name());
        Label plusForexFees = new Label(editArea, 0);
        plusForexFees.setText("+");
        AbstractTransactionDialog.Input forexFees = new AbstractTransactionDialog.Input(this, editArea, String.valueOf(this.sign()) + Messages.ColumnFees);
        forexFees.bindValue(AbstractSecurityTransactionModel.Properties.forexFees.name(), Messages.ColumnFees, Values.Amount, false);
        forexFees.bindCurrency(AbstractSecurityTransactionModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.Input fees = new AbstractTransactionDialog.Input(this, editArea, String.valueOf(this.sign()) + Messages.ColumnFees);
        fees.bindValue(AbstractSecurityTransactionModel.Properties.fees.name(), Messages.ColumnFees, Values.Amount, false);
        fees.bindCurrency(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name());
        Label plusForexTaxes = new Label(editArea, 0);
        plusForexTaxes.setText("+");
        AbstractTransactionDialog.Input forexTaxes = new AbstractTransactionDialog.Input(this, editArea, String.valueOf(this.sign()) + Messages.ColumnTaxes);
        forexTaxes.bindValue(AbstractSecurityTransactionModel.Properties.forexTaxes.name(), Messages.ColumnTaxes, Values.Amount, false);
        forexTaxes.bindCurrency(AbstractSecurityTransactionModel.Properties.securityCurrencyCode.name());
        AbstractTransactionDialog.Input taxes = new AbstractTransactionDialog.Input(this, editArea, String.valueOf(this.sign()) + Messages.ColumnTaxes);
        taxes.bindValue(AbstractSecurityTransactionModel.Properties.taxes.name(), Messages.ColumnTaxes, Values.Amount, false);
        taxes.bindCurrency(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name());
        String label = this.getTotalLabel();
        AbstractTransactionDialog.Input total = new AbstractTransactionDialog.Input(this, editArea, "= " + label);
        total.bindValue(AbstractSecurityTransactionModel.Properties.total.name(), label, Values.Amount, this.model().getType() != PortfolioTransaction.Type.DELIVERY_OUTBOUND);
        total.bindCurrency(AbstractSecurityTransactionModel.Properties.transactionCurrencyCode.name());
        Label lblNote = new Label(editArea, 16384);
        lblNote.setText(Messages.ColumnNote);
        Text valueNote = new Text(editArea, 2818);
        ISWTObservableValue targetNote = WidgetProperties.text((int)24).observe((Widget)valueNote);
        IObservableValue noteObservable = BeanProperties.value((String)AbstractSecurityTransactionModel.Properties.note.name()).observe((Object)this.model);
        this.context.bindValue((IObservableValue)targetNote, noteObservable);
        int width = SWTHelper.amountWidth((Drawable)grossValue.value);
        int currencyWidth = SWTHelper.currencyWidth((Drawable)grossValue.currency);
        int labelWidth = SWTHelper.widest(new Control[]{securities.label, portfolio.label, dateTime.label, shares.label, lblNote});
        FormDataFactory.startingWith(securities.value.getControl(), securities.label).suffix(securities.currency).thenBelow(portfolio.value.getControl()).label(portfolio.label).suffix(comboInput.value.getControl()).thenBelow(dateTime.date.getControl()).label(dateTime.label).thenRight((Control)dateTime.time).thenRight((Control)dateTime.button, 0);
        FormDataFactory.startingWith((Control)securities.label).width(labelWidth);
        FormDataFactory.startingWith(dateTime.date.getControl()).thenBelow((Control)shares.value).width(width).label(shares.label).thenRight((Control)quote.label).thenRight((Control)quote.value).width(width).thenRight((Control)quote.currency).width(width).thenRight((Control)grossValue.label).thenRight((Control)grossValue.value).width(width).thenRight((Control)grossValue.currency);
        FormDataFactory.startingWith((Control)quote.value).thenBelow((Control)exchangeRate.value).width(width).label(exchangeRate.label).thenRight((Control)exchangeRate.buttonInvertExchangeRate, 0).thenRight((Control)exchangeRate.currency).width(width);
        FormDataFactory.startingWith((Control)grossValue.value).thenBelow((Control)convertedGrossValue.value).width(width).label(convertedGrossValue.label).suffix(convertedGrossValue.currency).thenBelow((Control)fees.value).width(width).label(fees.label).suffix(fees.currency).thenBelow((Control)taxes.value).width(width).label(taxes.label).suffix(taxes.currency).thenBelow((Control)total.value).width(width).label(total.label).suffix(total.currency).thenBelow((Control)valueNote).height(SWTHelper.lineHeight((Control)valueNote) * 3).left(securities.value.getControl()).right((Control)total.value).label(lblNote);
        FormDataFactory.startingWith((Control)fees.value).thenLeft((Control)plusForexFees).thenLeft((Control)forexFees.currency).width(currencyWidth).thenLeft((Control)forexFees.value).width(width).thenLeft((Control)forexFees.label);
        FormDataFactory.startingWith((Control)taxes.value).thenLeft((Control)plusForexTaxes).thenLeft((Control)forexTaxes.currency).width(currencyWidth).thenLeft((Control)forexTaxes.value).width(width).thenLeft((Control)forexTaxes.label);
        this.model.addPropertyChangeListener(AbstractSecurityTransactionModel.Properties.exchangeRateCurrencies.name(), event -> {
            String securityCurrency = this.model().getSecurityCurrencyCode();
            String accountCurrency = this.model().getTransactionCurrencyCode();
            boolean visible = securityCurrency.length() > 0 && accountCurrency.length() > 0 && !securityCurrency.equals(accountCurrency);
            exchangeRate.setVisible(visible);
            convertedGrossValue.setVisible(visible);
            forexFees.setVisible(visible);
            plusForexFees.setVisible(visible);
            input3.label.setVisible(!visible);
            forexTaxes.setVisible(visible);
            plusForexTaxes.setVisible(visible);
            input5.label.setVisible(!visible);
            if (!visible) {
                this.model().setForexFees(0L);
                this.model().setForexTaxes(0L);
            }
        });
        WarningMessages warnings = new WarningMessages(this);
        warnings.add(() -> this.model().getDate().isAfter(LocalDate.now()) ? Messages.MsgDateIsInTheFuture : null);
        warnings.add(() -> new StockSplitWarning().check(this.model().getSecurity(), this.model().getDate()));
        this.model.addPropertyChangeListener(AbstractSecurityTransactionModel.Properties.security.name(), e -> warnings.check());
        this.model.addPropertyChangeListener(AbstractSecurityTransactionModel.Properties.date.name(), e -> warnings.check());
        this.model.firePropertyChange(AbstractSecurityTransactionModel.Properties.exchangeRateCurrencies.name(), "", this.model().getExchangeRateCurrencies());
    }

    private String sign() {
        switch (this.model().getType()) {
            case BUY: 
            case DELIVERY_INBOUND: {
                return "+ ";
            }
            case SELL: 
            case DELIVERY_OUTBOUND: {
                return "- ";
            }
        }
        throw new UnsupportedOperationException();
    }

    private String getTotalLabel() {
        switch (this.model().getType()) {
            case BUY: {
                return Messages.ColumnDebitNote;
            }
            case DELIVERY_INBOUND: {
                return Messages.LabelValueInboundDelivery;
            }
            case SELL: {
                return Messages.ColumnCreditNote;
            }
            case DELIVERY_OUTBOUND: {
                return Messages.LabelValueOutboundDelivery;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPortfolio(Portfolio portfolio) {
        this.model().setPortfolio(portfolio);
    }

    @Override
    public void setSecurity(Security security) {
        this.model().setSecurity(security);
    }

    public void setBuySellEntry(BuySellEntry entry) {
        if (!this.model().accepts(entry.getPortfolioTransaction().getType())) {
            throw new IllegalArgumentException();
        }
        this.model().setSource(entry);
    }

    public void setDeliveryTransaction(TransactionPair<PortfolioTransaction> pair) {
        if (!this.model().accepts(((PortfolioTransaction)pair.getTransaction()).getType())) {
            throw new IllegalArgumentException();
        }
        this.model().setSource(pair);
    }
}

