/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dnd;

import java.util.Objects;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;

abstract class AbstractDropAdapter
extends DropTargetAdapter {
    private final Transfer transfer;

    public AbstractDropAdapter(Transfer transfer, Control control) {
        this.transfer = Objects.requireNonNull(transfer);
        this.attach(control);
    }

    private void attach(Control control) {
        DropTarget dropTarget = this.findDropTarget(control);
        if (dropTarget != null) {
            this.registerWithExistingTarget(dropTarget);
        } else {
            dropTarget = new DropTarget(control, 23);
            dropTarget.setTransfer(new Transfer[]{this.transfer});
        }
        dropTarget.addDropListener((DropTargetListener)this);
    }

    private void registerWithExistingTarget(DropTarget target) {
        Transfer[] transfers = target.getTransfer();
        boolean exists = false;
        if (transfers != null) {
            Transfer[] transferArray = transfers;
            int n = transfers.length;
            int n2 = 0;
            while (n2 < n) {
                Transfer t = transferArray[n2];
                if (t.equals(this.transfer)) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                Transfer[] newTransfers = new Transfer[transfers.length + 1];
                System.arraycopy(transfers, 0, newTransfers, 0, transfers.length);
                newTransfers[transfers.length] = this.transfer;
                target.setTransfer(newTransfers);
            }
        }
    }

    private DropTarget findDropTarget(Control control) {
        if (control.isDisposed()) {
            return null;
        }
        Object object = control.getData("DropTarget");
        if (object instanceof DropTarget) {
            return (DropTarget)object;
        }
        return null;
    }

    public final void dragEnter(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public final void dragOver(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public final void dragLeave(DropTargetEvent e) {
        if (e.detail == 0) {
            this.setDropOperation(e);
        }
    }

    public final void dropAccept(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    public final void dragOperationChanged(DropTargetEvent e) {
        this.updateDragDetails(e);
    }

    private final void setDropOperation(DropTargetEvent e) {
        int allowedOperations = e.operations;
        int[] nArray = new int[]{16, 1, 2, 4};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int op = nArray[n2];
            if ((allowedOperations & op) != 0) {
                e.detail = op;
                return;
            }
            ++n2;
        }
        e.detail = allowedOperations;
    }

    private final void updateDragDetails(DropTargetEvent e) {
        if (this.isValidEvent(e)) {
            this.setDropOperation(e);
        }
    }

    protected boolean isValidEvent(DropTargetEvent e) {
        return this.transfer.isSupportedType(e.currentDataType);
    }

    public final void drop(DropTargetEvent event) {
        if (!this.transfer.isSupportedType(event.currentDataType)) {
            return;
        }
        if (event.data == null) {
            event.detail = 0;
            return;
        }
        if (!this.isValidEvent(event)) {
            event.detail = 0;
            return;
        }
        this.doDrop(event);
    }

    protected abstract void doDrop(DropTargetEvent var1);
}

