/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.dnd;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import name.abuchen.portfolio.ui.dnd.AbstractDropAdapter;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.ImportPDFHandler;
import name.abuchen.portfolio.ui.util.swt.ActiveShell;
import name.abuchen.portfolio.ui.wizards.datatransfer.CSVImportWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ImportFromFileDropAdapter
extends AbstractDropAdapter {
    private static final Pattern PDF_FILE = Pattern.compile(".*\\.pdf$", 2);
    private static final Pattern CSV_FILE = Pattern.compile(".*\\.csv$", 2);
    private final PortfolioPart part;

    private ImportFromFileDropAdapter(Transfer transfer, Control control, PortfolioPart part) {
        super(transfer, control);
        this.part = part;
    }

    public static void attach(Control control, PortfolioPart part) {
        new ImportFromFileDropAdapter((Transfer)FileTransfer.getInstance(), control, part);
    }

    @Override
    public void doDrop(DropTargetEvent event) {
        String[] files = (String[])event.data;
        if (files.length == 0) {
            event.detail = 0;
            return;
        }
        if (PDF_FILE.matcher(files[0]).matches()) {
            this.openPDFImport(event, files);
        } else if (CSV_FILE.matcher(files[0]).matches()) {
            this.openCSVImport(event, files);
        } else {
            event.detail = 0;
        }
    }

    private void openPDFImport(DropTargetEvent event, String[] fileNames) {
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            files.add(new File(f));
            ++n2;
        }
        DropTarget source = (DropTarget)event.getSource();
        Display display = source.getDisplay();
        display.asyncExec(() -> ImportPDFHandler.runImportWithFiles(this.part, ActiveShell.get(), this.part.getClient(), null, null, files));
    }

    private void openCSVImport(DropTargetEvent event, String[] fileNames) {
        DropTarget source = (DropTarget)event.getSource();
        Display display = source.getDisplay();
        display.asyncExec(() -> {
            CSVImportWizard wizard = new CSVImportWizard(this.part.getClient(), this.part.getPreferenceStore(), new File(fileNames[0]));
            this.part.inject((Object)wizard);
            WizardDialog wizwardDialog = new WizardDialog(ActiveShell.get(), (IWizard)wizard);
            wizwardDialog.open();
        });
    }
}

